/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.entity.components;

import com.rameses.entity.components.IAddressLookup;
import com.rameses.entity.components.IAddressLookupCaller;
import com.rameses.rcp.control.XButton;
import com.rameses.rcp.control.XComponentPanel;
import com.rameses.rcp.control.XTextArea;
import com.rameses.rcp.control.XToolBar;
import com.rameses.rcp.control.layout.YLayout;
import com.rameses.rcp.ui.annotations.ComponentBean;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.Beans;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

@ComponentBean(value="com.rameses.entity.components.EntityAddressLookupModel")
public class EntityAddressLookup
extends XComponentPanel {
    private String parentIdName = "entity.objid";
    private String showEditAddress;
    private String showAddressList;
    private String disableWhen;
    private boolean editable;
    private XButton btnEdit;
    private XButton btnViewAddress;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private XTextArea txtArea;
    private XToolBar xToolBar1;

    public EntityAddressLookup() {
        this.initComponents();
        this.txtArea.setEditable(false);
        this.txtArea.setEnabled(false);
    }

    public void afterRefresh() {
        boolean enabled = true;
        try {
            boolean disable = UIControlUtil.evaluateExprBoolean((Object)this.getBean(), (String)this.disableWhen);
            if (disable) {
                enabled = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.btnEdit.setEnabled(enabled);
        this.btnViewAddress.setEnabled(enabled);
    }

    public void afterLoad() {
        super.afterLoad();
        try {
            IAddressLookup comp = (IAddressLookup)this.getComponentBean();
            comp.setLookupCaller(new IAddressLookupCaller(){

                @Override
                public String getEntityid() {
                    return (String)EntityAddressLookup.this.getProperty(EntityAddressLookup.this.parentIdName);
                }

                @Override
                public boolean isShowEdit() {
                    if (EntityAddressLookup.this.showEditAddress == null) {
                        return true;
                    }
                    try {
                        return UIControlUtil.evaluateExprBoolean((Object)EntityAddressLookup.this.getBean(), (String)EntityAddressLookup.this.showEditAddress);
                    }
                    catch (Exception ign) {
                        return true;
                    }
                }

                @Override
                public boolean isShowList() {
                    if (EntityAddressLookup.this.showAddressList == null) {
                        return true;
                    }
                    try {
                        return UIControlUtil.evaluateExprBoolean((Object)EntityAddressLookup.this.getBean(), (String)EntityAddressLookup.this.showAddressList);
                    }
                    catch (Exception ign) {
                        return true;
                    }
                }
            });
        }
        catch (Exception e) {
            System.out.println("message error on setting property after load. " + e.getMessage());
        }
    }

    public void setEditable(boolean b) {
        this.editable = b;
        this.setEnabled(b);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEnabled(boolean b) {
        this.btnEdit.setEnabled(b);
    }

    public void setName(String name) {
        super.setName(name);
        if (Beans.isDesignTime()) {
            this.txtArea.setName(name);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.txtArea = new XTextArea();
        this.jPanel2 = new JPanel();
        this.xToolBar1 = new XToolBar();
        this.btnEdit = new XButton();
        this.btnViewAddress = new XButton();
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(200, 50));
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setBorder(BorderFactory.createLineBorder(new Color(180, 180, 180)));
        this.txtArea.setName("address.text");
        this.txtArea.setMargin(new Insets(4, 5, 1, 2));
        this.jScrollPane1.setViewportView((Component)this.txtArea);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.jScrollPane1, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout((LayoutManager)new YLayout());
        this.xToolBar1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.xToolBar1.setOpaque(false);
        this.btnEdit.setName("editAddress");
        this.btnEdit.setVisibleWhen("#{ showEdit }");
        this.btnEdit.setFocusable(false);
        this.btnEdit.setHorizontalTextPosition(0);
        this.btnEdit.setIconResource("images/toolbars/edit.png");
        this.btnEdit.setMargin(new Insets(0, 0, 0, 0));
        this.btnEdit.setToolTipText("Edit Address");
        this.btnEdit.setVerticalTextPosition(3);
        this.xToolBar1.add((Component)this.btnEdit);
        this.btnViewAddress.setCaption("");
        this.btnViewAddress.setName("viewAddress");
        this.btnViewAddress.setVisibleWhen("#{ showAddressList }");
        this.btnViewAddress.setFocusable(false);
        this.btnViewAddress.setHorizontalTextPosition(0);
        this.btnViewAddress.setIconResource("images/toolbars/create.png");
        this.btnViewAddress.setMargin(new Insets(0, 0, 0, 0));
        this.btnViewAddress.setToolTipText("View Address");
        this.btnViewAddress.setVerticalTextPosition(3);
        this.xToolBar1.add((Component)this.btnViewAddress);
        this.jPanel2.add((Component)this.xToolBar1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add(this.jPanel2, gridBagConstraints);
    }

    public String getParentIdName() {
        return this.parentIdName;
    }

    public void setParentIdName(String parentIdName) {
        this.parentIdName = parentIdName;
    }

    public String getShowEditAddress() {
        return this.showEditAddress;
    }

    public void setShowEditAddress(String showEditAddress) {
        this.showEditAddress = showEditAddress;
    }

    public String getShowAddressList() {
        return this.showAddressList;
    }

    public void setShowAddressList(String showAddressList) {
        this.showAddressList = showAddressList;
    }

    public String getDisableWhen() {
        return this.disableWhen;
    }

    public void setDisableWhen(String disableWhen) {
        this.disableWhen = disableWhen;
    }
}

