/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2;

import com.rameses.common.MethodResolver;
import com.rameses.common.PropertyResolver;
import com.rameses.osiris2.Module;
import com.rameses.osiris2.Page;
import com.rameses.osiris2.PageFlowInstance;
import com.rameses.osiris2.WorkUnit;
import com.rameses.osiris2.flow.AbstractNode;
import com.rameses.osiris2.flow.EndNode;
import com.rameses.osiris2.flow.PageFlow;
import com.rameses.osiris2.flow.PageNode;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WorkUnitInstance
implements Serializable {
    WorkUnit workunit;
    private Object controller;
    private Page currentPage;
    private PageFlowInstance pageFlowInstance;
    private String title;
    private String id;

    public WorkUnitInstance(WorkUnit workunit) {
        this.workunit = workunit;
        this.id = workunit.getId();
        this.title = workunit.getTitle();
        try {
            this.currentPage = this.getDefaultPage();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getController() {
        if (this.controller == null) {
            try {
                this.controller = this.workunit.getCodeInstance();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
        return this.controller;
    }

    public Page getDefaultPage() {
        return this.workunit.getDefaultPage();
    }

    public Page getPage(String name) {
        return (Page)this.workunit.getPages().get(name);
    }

    public Page getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(String name) {
        this.currentPage = name == null ? null : (Page)this.workunit.getPages().get(name);
    }

    public PageFlow getPageFlow() {
        return this.getWorkunit().getPageFlow();
    }

    private PageFlowInstance getPageFlowInstance() {
        if (this.pageFlowInstance == null) {
            if (this.getPageFlow() == null) {
                return null;
            }
            this.pageFlowInstance = new PageFlowInstance(this);
        }
        return this.pageFlowInstance;
    }

    public AbstractNode getCurrentNode() {
        return this.getPageFlowInstance().getCurrentNode();
    }

    public List getTransitions() {
        return this.getPageFlowInstance().getTransitions();
    }

    public String getStateTitle() {
        return this.getPageFlowInstance().getCurrentNode().getTitle();
    }

    public boolean isStarted() {
        return this.getPageFlowInstance().isStarted();
    }

    public void start() {
        this.signal();
    }

    public void start(String m) {
        this.signal(m);
    }

    public void signal() {
        this.signal(null);
    }

    public void signal(String transition) {
        PageFlowInstance p = this.getPageFlowInstance();
        p.signal(transition);
        if (p.getCurrentNode() instanceof PageNode) {
            PageNode pg = (PageNode)p.getCurrentNode();
            this.setCurrentPage(pg.getName());
        } else if (p.getCurrentNode() instanceof EndNode) {
            Page pg;
            EndNode en = (EndNode)p.getCurrentNode();
            String ename = en.getName();
            if (ename == null || ename.length() == 0) {
                ename = "end";
            }
            if ((pg = this.getPage(ename)) == null) {
                ename = null;
            }
            this.setCurrentPage(ename);
        }
    }

    public void copyProperties(Map props) {
        Iterator iter = props.entrySet().iterator();
        PropertyResolver resolver = PropertyResolver.getInstance();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            try {
                resolver.setProperty(this.getController(), me.getKey() + "", me.getValue());
            }
            catch (Exception ex) {
                System.out.println("error in WorkUnitInstance.copyProperties. " + ex.getMessage());
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WorkUnit getWorkunit() {
        return this.workunit;
    }

    public Module getModule() {
        return this.workunit.getModule();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof WorkUnitInstance)) {
            return false;
        }
        WorkUnitInstance wi = (WorkUnitInstance)object;
        return this.hashCode() == wi.hashCode();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean isPageFlowCompleted() {
        return this.getPageFlowInstance().isEnded();
    }

    public void invoke(String method) {
        if (method != null && method.trim().length() > 0) {
            try {
                MethodResolver mr = MethodResolver.getInstance();
                Object o = mr.invoke(this.getController(), method, null);
                if (o != null && o instanceof String) {
                    String p = (String)o;
                    this.setCurrentPage(p);
                }
                if (this.getCurrentPage() == null) {
                    this.setCurrentPage("default");
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
    }

    public void setProperty(String name, Object value) {
        try {
            PropertyResolver.getInstance().setProperty(this.getController(), name, value);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public void setProperties(Map params) {
        if (params != null) {
            for (Map.Entry me : params.entrySet()) {
                String k = me.getKey() + "";
                Object v = me.getValue();
                this.setProperty(k, v);
            }
        }
    }

    public void fireAction(String msg) {
        if (this.getPageFlow() != null) {
            this.signal(msg);
        } else {
            this.invoke(msg);
        }
    }
}

