/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2;

import com.rameses.common.ExpressionResolver;
import com.rameses.common.MethodResolver;
import com.rameses.osiris2.WorkUnitInstance;
import com.rameses.osiris2.flow.AbstractNode;
import com.rameses.osiris2.flow.EndNode;
import com.rameses.osiris2.flow.PageFlow;
import com.rameses.osiris2.flow.PageNode;
import com.rameses.osiris2.flow.ProcessNode;
import com.rameses.osiris2.flow.StartNode;
import com.rameses.osiris2.flow.Transition;
import com.rameses.util.BreakException;
import com.rameses.util.ExceptionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PageFlowInstance {
    private AbstractNode currentNode;
    private String name;
    private WorkUnitInstance workunit;

    PageFlowInstance(WorkUnitInstance wui) {
        this.workunit = wui;
        this.currentNode = wui.getPageFlow().getStart();
    }

    public PageFlow getPageFlow() {
        return this.workunit.getPageFlow();
    }

    public void signal() {
        this.signal(null);
    }

    public void signal(String n) {
        AbstractNode tmp = this.signalNode(this.currentNode, n);
        if (tmp != null) {
            this.currentNode = tmp;
        }
    }

    private AbstractNode signalNode(AbstractNode prevNode, String n) {
        try {
            Object data = this.workunit.getController();
            Transition t = this.findTransition(prevNode, n, data);
            if (t == null) {
                return null;
            }
            this.fireTransitionAction(t);
            String to = t.getTo();
            try {
                to = ExpressionResolver.getInstance().evalString(to, data);
            }
            catch (Exception ex) {
                System.out.println("error pageflow rendered expr " + to + "->" + ex.getMessage());
            }
            AbstractNode tempNode = this.findNode(to);
            this.fireNodeAction(tempNode);
            if (tempNode instanceof ProcessNode) {
                return this.signalNode(tempNode, null);
            }
            return tempNode;
        }
        catch (BreakException be) {
            return null;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private Transition findTransition(AbstractNode node, String name, Object data) {
        Iterator iter = node.getTransitions().iterator();
        if (name != null && name.length() > 0) {
            while (iter.hasNext()) {
                Transition t = (Transition)iter.next();
                if (!this.isRendered(t, data) || !name.equals(t.getName())) continue;
                return t;
            }
        } else {
            while (iter.hasNext()) {
                Transition t = (Transition)iter.next();
                if (!this.isRendered(t, data) || !this.isMatchedCondition(t, data)) continue;
                return t;
            }
        }
        return null;
    }

    private boolean isMatchedCondition(Transition t, Object data) {
        if (t.getCond() != null) {
            try {
                return ExpressionResolver.getInstance().evalBoolean(t.getCond(), data);
            }
            catch (Exception ex) {
                System.out.println("error pageflow rendered expr " + t.getName() + "->" + ex.getMessage());
                return false;
            }
        }
        return true;
    }

    private boolean isRendered(Transition t, Object data) {
        if (t.getRendered() != null) {
            try {
                return ExpressionResolver.getInstance().evalBoolean(t.getRendered(), data);
            }
            catch (Exception ex) {
                System.out.println("error pageflow rendered expr " + t.getName() + "->" + ex.getMessage());
                return false;
            }
        }
        return true;
    }

    private AbstractNode findNode(String n) {
        for (AbstractNode anode : this.getPageFlow().getNodes()) {
            if (!anode.getName().equals(n)) continue;
            return anode;
        }
        return null;
    }

    private void fireTransitionAction(Transition t) throws Exception {
        if (t.getAction() != null) {
            try {
                MethodResolver.getInstance().invoke(this.workunit.getController(), t.getAction(), null);
            }
            catch (Exception e) {
                System.out.println("[PageFlowInstance] fireTransitionAction error...");
                e.printStackTrace();
                throw ExceptionManager.getOriginal((Exception)e);
            }
        }
    }

    private void fireNodeAction(AbstractNode aNode) throws Exception {
        String act = null;
        if (aNode instanceof PageNode) {
            act = ((PageNode)aNode).getAction();
        } else if (aNode instanceof ProcessNode) {
            act = ((ProcessNode)aNode).getAction();
        }
        if (act != null) {
            MethodResolver.getInstance().invoke(this.workunit.getController(), act, null);
        }
    }

    public List getTransitions() {
        Object bean = this.workunit.getController();
        ArrayList<Transition> trans = new ArrayList<Transition>();
        for (Transition t : this.currentNode.getTransitions()) {
            if (!this.isRendered(t, bean)) continue;
            trans.add(t);
        }
        return trans;
    }

    public AbstractNode getCurrentNode() {
        return this.currentNode;
    }

    public boolean isEnded() {
        return this.currentNode instanceof EndNode;
    }

    public boolean isStarted() {
        return !(this.currentNode instanceof StartNode);
    }
}

