/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2;

import com.rameses.osiris2.AppContext;
import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.WorkUnit;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class Module {
    private URL url;
    private AppContext context;
    private String contextPath;
    private String platform;
    private String channel;
    private String domain;
    private String name;
    private String title;
    private Map properties = new HashMap();
    private Map workunits = new Hashtable();
    private List<Invoker> invokers = new ArrayList<Invoker>();

    Module(AppContext ctx, URL url, Map conf) {
        this.contextPath = url.toExternalForm().replaceAll("/META-INF/module.conf", "");
        this.contextPath = this.contextPath.replaceAll("\\s", "%20");
        this.platform = this.getString(conf, "platform");
        this.channel = this.getString(conf, "channel");
        this.domain = this.getString(conf, "domain");
        this.context = ctx;
        this.url = url;
    }

    private String getString(Map conf, Object key) {
        Object value = conf == null ? null : (Object)conf.get(key);
        return value == null ? null : value.toString();
    }

    public AppContext getAppContext() {
        return this.context;
    }

    public URL getURL() {
        return this.url;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    @Deprecated
    public String getPlatform() {
        return this.platform;
    }

    @Deprecated
    public String getChannel() {
        return this.channel;
    }

    public String getDomain() {
        return this.domain;
    }

    public Map getProperties() {
        return this.properties;
    }

    public Map getWorkUnits() {
        return this.workunits;
    }

    public List<Invoker> getInvokers() {
        return this.invokers;
    }

    public String getNamespace() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public WorkUnit getWorkunit(String name) {
        return (WorkUnit)this.workunits.get(name);
    }

    public InputStream getResourceAsStream(String name) {
        try {
            URL res = this.getResource(name);
            return res == null ? null : res.openStream();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public URL getResource(String name) {
        try {
            if (name == null) {
                return null;
            }
            String prefix = name.startsWith("/") ? "" : "/";
            return new URL(this.contextPath + prefix + name);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }
}

