/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import java.io.File;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;

public final class URLUtil {
    public static URL getParentUrl(URL u) {
        try {
            String s = u.toExternalForm();
            s = s.substring(0, s.lastIndexOf("/"));
            return new URL(s);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static URL getSubUrl(URL u, String subDirectory) {
        try {
            String s = u.toExternalForm();
            if (subDirectory.startsWith("/")) {
                subDirectory = subDirectory.substring(1);
            }
            s = s.endsWith("/") ? s + subDirectory : s + "/" + subDirectory;
            return new URL(s);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static boolean exists(URL url, String fileName) {
        try {
            URLConnection conn = url.openConnection();
            if (conn instanceof JarURLConnection) {
                JarURLConnection jurl = (JarURLConnection)conn;
                JarFile jf = jurl.getJarFile();
                return jf.getEntry(fileName) != null;
            }
            if (conn instanceof HttpURLConnection) {
                throw new Exception("Http URL Connection is not supported at this time.");
            }
            String urlFile = url.getFile();
            if (urlFile.endsWith(".jar")) {
                throw new Exception("URLUtil.exists error. File names that does not end with .jar not yet handled");
            }
            File f = new File(url.getFile(), fileName);
            return f.exists();
        }
        catch (Exception e) {
            return false;
        }
    }
}

