/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import com.rameses.util.Service;
import com.rameses.util.URLStreamHandler;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class URLStreamHandlerFactory {
    private static final Map<String, URLStreamHandlerProxy> URL_HANDLERS = new HashMap<String, URLStreamHandlerProxy>();
    private ClassLoader loader;

    public static URLStreamHandlerFactory getInstance() {
        return URLStreamHandlerFactory.getInstance(null);
    }

    public static URLStreamHandlerFactory getInstance(ClassLoader loader) {
        return new URLStreamHandlerFactory(loader);
    }

    private URLStreamHandlerFactory(ClassLoader loader) {
        if (loader == null) {
            loader = URLStreamHandlerFactory.class.getClassLoader();
        }
        this.loader = loader;
    }

    public URLStreamHandler getHandler(String protocol) {
        if (protocol == null || protocol.trim().length() == 0) {
            return null;
        }
        return URL_HANDLERS.get(protocol.toLowerCase());
    }

    public URL getResource(String spath) {
        if (spath == null || spath.trim().length() == 0) {
            return null;
        }
        int idx = spath.indexOf("://");
        if (idx <= 0) {
            URL result = this.loader.getResource(spath);
            if (result == null) {
                URLStreamHandlerFactory uRLStreamHandlerFactory = this;
                result = uRLStreamHandlerFactory.loader.getSystemClassLoader().getResource(spath);
            }
            return result;
        }
        String protocol = spath.toLowerCase().substring(0, idx);
        URLStreamHandlerProxy proxy = URL_HANDLERS.get(protocol);
        if (proxy != null) {
            proxy.setClassLoader(this.loader);
            return proxy.getResource(spath.substring(idx + 3));
        }
        return null;
    }

    static {
        Iterator itr = Service.providers(URLStreamHandler.class, URLStreamHandlerFactory.class.getClassLoader());
        while (itr.hasNext()) {
            URLStreamHandler handler = (URLStreamHandler)itr.next();
            String protocol = handler.getProtocol();
            if (protocol == null || protocol.trim().length() <= 0) continue;
            String sname = protocol.toLowerCase();
            URLStreamHandlerProxy proxy = URL_HANDLERS.get(sname);
            if (proxy == null) {
                proxy = new URLStreamHandlerProxy(sname);
                URL_HANDLERS.put(sname, proxy);
            }
            proxy.add(handler);
        }
    }

    private static class URLStreamHandlerProxy
    extends URLStreamHandler {
        private String protocol;
        private List<URLStreamHandler> handlers;

        URLStreamHandlerProxy(String protocol) {
            this.protocol = protocol;
            this.handlers = new ArrayList<URLStreamHandler>();
        }

        @Override
        public String getProtocol() {
            return this.protocol;
        }

        public void add(URLStreamHandler o) {
            if (o != null && !this.handlers.contains(o)) {
                this.handlers.add(o);
            }
        }

        public void removeAll() {
            this.handlers.clear();
        }

        @Override
        public URL getResource(String spath) {
            for (URLStreamHandler handler : this.handlers) {
                handler.setClassLoader(this.getClassLoader());
                URL result = handler.getResource(spath);
                if (result == null) continue;
                return result;
            }
            return null;
        }
    }
}

