/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public abstract class URLStreamHandler
extends java.net.URLStreamHandler {
    private ClassLoader classLoader;
    private int index;

    public abstract String getProtocol();

    public abstract URL getResource(String var1);

    public int getIndex() {
        return this.index;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        String[] values = new String[]{url.getHost(), url.getPath()};
        String respath = this.join(values);
        if (respath.startsWith("/")) {
            respath = respath.substring(1);
        }
        if (respath == null || respath.trim().length() == 0) {
            return null;
        }
        URL result = this.getResource(respath);
        if (result == null) {
            return new EmptyURLConnection(url);
        }
        return result.openConnection();
    }

    private String join(String[] values) {
        StringBuilder sb = new StringBuilder();
        for (String str : values) {
            if (str == null || str.trim().length() == 0) continue;
            sb.append(str);
        }
        return sb.toString();
    }

    private class EmptyURLConnection
    extends URLConnection {
        protected EmptyURLConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
            this.connected = true;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(new byte[0]);
        }
    }
}

