/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import com.rameses.util.Service;
import com.rameses.util.TemplateSource;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public abstract class TemplateProvider
implements Serializable {
    private static TemplateProvider instance;

    public abstract String[] getExtensions();

    public abstract Object getResult(String var1, Object var2);

    public abstract Object getResult(String var1, Object var2, TemplateSource var3);

    public abstract void transform(String var1, Object var2, OutputStream var3);

    public abstract void transform(String var1, Object var2, OutputStream var3, TemplateSource var4);

    public abstract void clear(String var1);

    public static void setInstance(TemplateProvider tp) {
        instance = tp;
    }

    public static TemplateProvider getInstance() {
        if (instance == null) {
            instance = new DefaultTemplateProvider();
        }
        return instance;
    }

    public static class ClassLoaderSourceProvider
    implements TemplateSource {
        @Override
        public InputStream getSource(String name) {
            InputStream is = null;
            try {
                is = name.indexOf("://") < 0 ? this.getClass().getClassLoader().getResourceAsStream(name) : new URL(name).openStream();
                return is;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public static class DefaultTemplateProvider
    extends TemplateProvider {
        private Map<String, TemplateProvider> providers = new Hashtable<String, TemplateProvider>();

        public DefaultTemplateProvider() {
            Iterator iter = Service.providers(TemplateProvider.class, this.getClass().getClassLoader());
            while (iter.hasNext()) {
                TemplateProvider tp = (TemplateProvider)iter.next();
                for (String s : tp.getExtensions()) {
                    this.providers.put(s, tp);
                }
            }
        }

        private TemplateProvider getProvider(String ext) {
            if (!this.providers.containsKey(ext)) {
                throw new RuntimeException("There is no template handler found for " + ext);
            }
            return this.providers.get(ext);
        }

        @Override
        public String[] getExtensions() {
            return null;
        }

        @Override
        public Object getResult(String name, Object data) {
            return this.getResult(name, data, null);
        }

        @Override
        public Object getResult(String name, Object data, TemplateSource source) {
            if (source == null) {
                source = new ClassLoaderSourceProvider();
            }
            String ext = name.substring(name.lastIndexOf(".") + 1);
            TemplateProvider t = this.getProvider(ext);
            return t.getResult(name, data, source);
        }

        @Override
        public void transform(String name, Object data, OutputStream out) {
            this.transform(name, data, out, null);
        }

        @Override
        public void transform(String name, Object data, OutputStream out, TemplateSource source) {
            String ext = name.substring(name.lastIndexOf(".") + 1);
            TemplateProvider t = this.getProvider(ext);
            t.transform(name, data, out, source);
        }

        @Override
        public void clear(String name) {
            if (name == null || name.trim().length() == 0) {
                Iterator<TemplateProvider> iter = this.providers.values().iterator();
                while (iter.hasNext()) {
                    try {
                        TemplateProvider tp = iter.next();
                        tp.clear(null);
                    }
                    catch (Exception ign) {
                        System.out.println("[WARN]" + ign.getMessage());
                    }
                }
            } else {
                String ext = name.substring(name.lastIndexOf(".") + 1);
                TemplateProvider t = this.getProvider(ext);
                t.clear(name);
            }
        }
    }
}

