/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import com.rameses.util.ObjectScanner;
import com.rameses.util.ValueUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class ObjectSerializer {
    private static ObjectSerializer instance;

    public static ObjectSerializer getInstance() {
        if (instance == null) {
            instance = new ObjectSerializer();
        }
        return instance;
    }

    public String toString(Object data) {
        if (data == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        this.stringifyMap(data, writer);
        return ((Object)writer).toString();
    }

    public void write(Object data, Writer writer) {
        try {
            if (data instanceof String) {
                return;
            }
            this.stringifyMap(data, writer);
            writer.flush();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private void stringifyMap(Object data, Writer writer) {
        ScanHandler scanHandler = new ScanHandler(writer);
        ObjectScanner scanner = new ObjectScanner(scanHandler);
        scanner.scan(data);
    }

    private String correctKeyName(String n) {
        if (n.contains(".") || n.contains("[") || n.contains("]") || n.contains(" ")) {
            return "\"" + n + "\"";
        }
        return n;
    }

    private class ScanHandler
    implements ObjectScanner.ObjectScannerHandler {
        private Writer writer;

        ScanHandler(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void emptyElement(String name, Object value, int pos) {
            try {
                if (pos > 0) {
                    this.writer.write(",");
                }
                if (name != null) {
                    this.writer.write(ObjectSerializer.this.correctKeyName(name) + ":");
                }
                if (value instanceof Map) {
                    this.writer.write("[:]");
                } else if (value instanceof List) {
                    this.writer.write("[]");
                } else {
                    this.writer.write("null");
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        @Override
        public void startElement(String name, int pos) {
            try {
                if (pos > 0) {
                    this.writer.write(",");
                }
                if (name != null) {
                    this.writer.write(ObjectSerializer.this.correctKeyName(name) + ":");
                }
                this.writer.write("[");
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        @Override
        public void property(String name, Object value, int pos) {
            try {
                if (pos > 0) {
                    this.writer.write(",");
                }
                if (name != null) {
                    this.writer.write(ObjectSerializer.this.correctKeyName(name) + ":");
                }
                if (value == null) {
                    this.writer.write("null");
                } else {
                    this.writer.write(ValueUtil.getValueAsString(value.getClass(), value));
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        @Override
        public void endElement(String name) {
            try {
                this.writer.write("]");
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        @Override
        public void endDocument() {
        }
    }
}

