/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import com.rameses.util.DateUtil;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class ObjectPool {
    private LinkedBlockingQueue<PooledItem> pool = new LinkedBlockingQueue();
    private Date lastAccessed = new Date();
    private PoolSource poolSource;
    private int minSize = 5;
    private int maxSize = 100;
    private ScheduledExecutorService cleaner = Executors.newScheduledThreadPool(1);

    public ObjectPool(PoolSource source) {
        this(source, 5);
    }

    public ObjectPool(PoolSource source, int minSize) {
        this(source, 5, 100);
    }

    public ObjectPool(PoolSource source, int minSize, int maxSize) {
        this.poolSource = source;
        if (minSize > 0) {
            this.minSize = minSize;
        }
        this.maxSize = maxSize > minSize ? maxSize : minSize + 100;
        this.init();
        this.cleaner.scheduleWithFixedDelay(new Cleaner(), 60L, 60L, TimeUnit.SECONDS);
    }

    public void destroy() {
        this.cleaner.shutdown();
        this.poolSource = null;
    }

    private void init() {
        for (int i = 0; i < this.minSize; ++i) {
            this.pool.add(new PooledItem(this, this.poolSource.createObject()));
        }
        this.lastAccessed = new Date();
    }

    public int getPoolSize() {
        return this.pool.size();
    }

    public Object request() {
        PooledItem pi = this.pool.poll();
        if (pi == null) {
            pi = new PooledItem(this, this.poolSource.createObject());
        }
        return pi;
    }

    boolean sendBackToPool(PooledItem item) {
        this.lastAccessed = new Date();
        if (this.pool.size() > this.maxSize) {
            item.destroy();
            return false;
        }
        boolean added = this.pool.offer(item);
        if (!added) {
            item.destroy();
            return false;
        }
        return true;
    }

    public boolean remove(PooledItem item) {
        return this.pool.remove(item);
    }

    public static final class PooledItem {
        private ObjectPool manager;
        private Object pooledObject;

        PooledItem(ObjectPool manager, Object pooledObj) {
            this.pooledObject = pooledObj;
            this.manager = manager;
        }

        public boolean close() {
            return this.manager.sendBackToPool(this);
        }

        public void destroy() {
            this.manager = null;
            this.pooledObject = null;
        }

        public void removeFromPool() {
            if (this.manager.remove(this)) {
                this.destroy();
            }
        }
    }

    public static interface PoolSource {
        public Object createObject();
    }

    private class Cleaner
    implements Runnable {
        private Cleaner() {
        }

        @Override
        public void run() {
            try {
                Date lastAccessed = ObjectPool.this.lastAccessed;
                Date today = new Date();
                long diff = DateUtil.diff(lastAccessed, today, 13);
                if (diff > 60L && ObjectPool.this.pool.size() > ObjectPool.this.minSize) {
                    System.out.println("start cleanup mainetenance");
                    Vector deadPool = new Vector();
                    ObjectPool.this.pool.drainTo(deadPool);
                    ObjectPool.this.init();
                    for (PooledItem pi : deadPool) {
                        pi.destroy();
                    }
                }
            }
            catch (Exception ign) {
                System.out.println("cleanup error");
            }
        }
    }
}

