/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;

public class NumberToWords {
    private static NumberToWords instance;
    private DecimalFormat _formatter = new DecimalFormat("0.00");
    private static final String[] majorNames;
    private static final String[] tensNames;
    private static final String[] numNames;

    public static NumberToWords getInstance() {
        if (instance == null) {
            instance = new NumberToWords();
        }
        return instance;
    }

    private String convertLessThanOneThousand(int number) {
        String soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            number /= 100;
        } else {
            soFar = numNames[number % 10];
            soFar = tensNames[(number /= 10) % 10] + soFar;
            number /= 10;
        }
        if (number == 0) {
            return soFar;
        }
        return numNames[number] + " hundred" + soFar;
    }

    public String convert(int value) {
        return this.convert((long)value);
    }

    public String convert(long value) {
        if (value == 0L) {
            return "zero";
        }
        String prefix = "";
        if (value < 0L) {
            value = -value;
            prefix = "negative";
        }
        String soFar = "";
        int place = 0;
        do {
            long n;
            if ((n = value % 1000L) != 0L) {
                String s = this.convertLessThanOneThousand((int)n);
                soFar = s + majorNames[place] + soFar;
            }
            ++place;
        } while ((value /= 1000L) > 0L);
        return (prefix + soFar).trim();
    }

    public String convert(float value) {
        Float num = Float.valueOf(value);
        return this.convert(new BigDecimal(((Object)num).toString()));
    }

    public String convert(double value) {
        Double num = value;
        return this.convert(new BigDecimal(((Object)num).toString()));
    }

    public String convert(BigDecimal dec) {
        BigDecimal leftNum;
        BigInteger rightNum = (dec = new BigDecimal(this._formatter.format(dec))).subtract(leftNum = new BigDecimal(dec.longValue())).unscaledValue();
        if (rightNum.longValue() < 0L) {
            rightNum = rightNum.negate();
        }
        StringBuilder buff = new StringBuilder();
        buff.append(this.convert(leftNum.longValue()));
        if (rightNum.longValue() > 0L) {
            buff.append(" AND ");
            buff.append(rightNum.intValue());
            buff.append("/100");
        }
        return buff.toString().toUpperCase();
    }

    public String getCents(String cents) {
        cents = this._formatter.format(Double.valueOf("." + cents));
        return cents.substring(cents.indexOf(".") + 1);
    }

    static {
        majorNames = new String[]{"", " thousand", " million", " billion", " trillion", " quadrillion", " quintillion"};
        tensNames = new String[]{"", " ten", " twenty", " thirty", " forty", " fifty", " sixty", " seventy", " eighty", " ninety"};
        numNames = new String[]{"", " one", " two", " three", " four", " five", " six", " seven", " eight", " nine", " ten", " eleven", " twelve", " thirteen", " fourteen", " fifteen", " sixteen", " seventeen", " eighteen", " nineteen"};
    }
}

