/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import com.rameses.util.ListEditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class MapEditor
extends HashMap {
    private boolean editmode = true;
    private Map data;
    private Map<String, ListEditor> listEditors = new Hashtable<String, ListEditor>();
    private Map<String, MapEditor> mapEditors = new Hashtable<String, MapEditor>();

    public MapEditor(Map data, boolean editmode) {
        this.data = data;
        this.editmode = editmode;
        if (!editmode) {
            this.data.put("_new", true);
        }
    }

    public MapEditor(Map data) {
        this.data = data;
    }

    @Override
    public Object get(Object key) {
        String skey = key + "";
        Object val = this.data.get(skey);
        if (val instanceof List) {
            List list = (List)val;
            if (!this.listEditors.containsKey(skey)) {
                this.listEditors.put(skey, new ListEditor(this, skey, list));
            }
            val = this.listEditors.get(skey);
        } else if (val instanceof Map) {
            Map map = (Map)val;
            if (!this.mapEditors.containsKey(skey)) {
                this.mapEditors.put(skey, new MapEditor(map));
            }
            val = this.mapEditors.get(skey);
        }
        return val;
    }

    @Override
    public Object put(Object key, Object value) {
        String marker = "_" + key;
        if (!this.data.containsKey(key)) {
            this.data.put(key, value);
            if (this.editmode) {
                this.data.put(marker, value);
            }
        } else {
            if (this.editmode) {
                Object oldValue = this.data.get(key);
                if (oldValue == null && value == null) {
                    return value;
                }
                if (oldValue != null && oldValue.equals(value)) {
                    return value;
                }
                if (this.data.containsKey(marker)) {
                    Object origValue = this.data.get(marker);
                    if (origValue == null && value == null || origValue != null && origValue.equals(value)) {
                        this.data.remove(marker);
                    }
                } else {
                    this.data.put(marker, oldValue);
                }
            }
            this.data.put(key, value);
        }
        return value;
    }

    public Map changes() {
        boolean newData = false;
        try {
            newData = Boolean.parseBoolean(this.data.get("_new") + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (newData) {
            return this.data;
        }
        ArrayList<String> changes = new ArrayList<String>();
        for (Map.Entry o : this.data.entrySet()) {
            Map.Entry me = o;
            String skey = me.getKey() + "";
            if (!skey.startsWith("_")) continue;
            changes.add(skey);
        }
        HashMap map = new HashMap();
        ArrayList deletedItems = new ArrayList();
        for (String s : changes) {
            String n = s.substring(1);
            if (!this.data.containsKey(n)) continue;
            map.put(n, this.data.get(n));
        }
        return map;
    }
}

