/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import com.rameses.util.Base64Cipher;
import java.security.SecureRandom;

public final class KeyGen {
    private static final Object TREE_LOCK = new Object();
    private static final Provider impl = new KeyGen().newProviderImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Provider newProvider() {
        Object object = TREE_LOCK;
        synchronized (object) {
            return new KeyGen().newProviderImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String generateIntKey(String prefix, int length) {
        Object object = TREE_LOCK;
        synchronized (object) {
            return impl.generateIntKey(prefix, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String generateAlphanumKey(String prefix, int length) {
        Object object = TREE_LOCK;
        synchronized (object) {
            return impl.generateAlphanumKey(prefix, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String generateToken() {
        Object object = TREE_LOCK;
        synchronized (object) {
            return impl.generateToken();
        }
    }

    private final Provider newProviderImpl() {
        return new ProviderImpl();
    }

    private class ProviderImpl
    implements Provider {
        private ProviderImpl() {
        }

        @Override
        public String generateToken() {
            SecureRandom sr = new SecureRandom();
            byte[] bytes = new byte[24];
            sr.nextBytes(bytes);
            String str = new Base64Cipher().encode(bytes);
            return str.replace('/', 'S').replace('+', 'P');
        }

        @Override
        public String generateIntKey(String prefix, int length) {
            String snum = this.getSecuredRandom().nextInt() + "";
            StringBuffer key = new StringBuffer();
            if (prefix != null) {
                key.append(prefix.toString().replaceAll(" ", "").trim());
            }
            if (snum.length() < 10) {
                int len = 10 - snum.length();
                for (int i = 0; i < len; ++i) {
                    key.append("0");
                }
            }
            key.append(snum);
            return key.toString();
        }

        @Override
        public String generateAlphanumKey(String prefix, int length) {
            String alphanum = "ACDEFHJKLMNPQRTUVWXY1234567890";
            StringBuffer sbuff = new StringBuffer();
            if (prefix != null) {
                sbuff.append(prefix);
            }
            SecureRandom sr = this.getSecuredRandom();
            for (int i = 0; i < length; ++i) {
                int idx = (int)(sr.nextDouble() * (double)alphanum.length());
                sbuff.append(alphanum.substring(idx, idx + 1));
            }
            return sbuff.toString();
        }

        @Override
        public String generateRandomKey(String prefix) {
            SecureRandom sr = this.getSecuredRandom();
            int inum = sr.nextInt();
            String spre = inum < 0 ? "1" : "0";
            String snum = inum + "";
            snum = snum.replaceFirst("-", "");
            String sval = spre + this.padLeft(snum, 10, "0");
            if (prefix == null || prefix.trim().length() == 0) {
                return sval;
            }
            return prefix + sval;
        }

        private SecureRandom getSecuredRandom() {
            SecureRandom sr = new SecureRandom();
            sr.setSeed(System.currentTimeMillis() + (long)System.identityHashCode(sr));
            return sr;
        }

        private String padLeft(String text, int length, String prefix) {
            StringBuilder sb = new StringBuilder();
            int diff = Math.max(length - text.length(), 0);
            if (diff > 0 && prefix != null) {
                for (int i = 0; i < diff; ++i) {
                    sb.append(prefix);
                }
            }
            sb.append(text);
            return sb.toString();
        }
    }

    public static interface Provider {
        public String generateIntKey(String var1, int var2);

        public String generateAlphanumKey(String var1, int var2);

        public String generateRandomKey(String var1);

        public String generateToken();
    }
}

