/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import java.util.Map;

public class HTMLBuilder {
    private static String defaultStyle = "body { font-family: Arial; font-size: 11pt; }";
    private Map data;
    private Map meta;
    private String style;
    private String html;

    public static String toString(Map data) {
        return HTMLBuilder.toString(data, null);
    }

    public static String toString(Map data, String style) {
        return new HTMLBuilder(data, null, style).toString();
    }

    public HTMLBuilder() {
    }

    public HTMLBuilder(Map data) {
        this(data, null);
    }

    public HTMLBuilder(Map data, Map meta) {
        this(data, meta, null);
    }

    public HTMLBuilder(Map data, Map meta, String style) {
        this.data = data;
        this.meta = meta;
        this.style = style;
    }

    public void rebuild() {
        this.html = null;
        this.toString();
    }

    public String toString() {
        if (this.html == null) {
            String ss = this.style != null ? this.style : defaultStyle;
            this.html = "<html><style>" + ss + "</style><body>" + this.doToString(this.data, this.meta) + "</body></html>";
        }
        return this.html;
    }

    private String doToString(Map data, Map metaData) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<table>");
        for (Map.Entry me : data.entrySet()) {
            Map def = metaData == null ? null : (Map)metaData.get(me.getKey());
            String caption = null;
            caption = def != null && def.get("caption") != null ? def.get("caption") + "" : me.getKey() + "";
            buffer.append("<tr>");
            buffer.append("<td valign='top'><b>" + caption + " :</b></td>");
            Object value = me.getValue();
            buffer.append("<td valign='top'>");
            if (value instanceof Map) {
                buffer.append(this.doToString((Map)value, def));
            } else {
                buffer.append(value);
            }
            buffer.append("</td>");
            buffer.append("</tr>");
        }
        buffer.append("</table>");
        return buffer.toString();
    }

    public Map getData() {
        return this.data;
    }

    public void setData(Map data) {
        this.data = data;
    }

    public Map getMeta() {
        return this.meta;
    }

    public void setMeta(Map meta) {
        this.meta = meta;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }
}

