/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import com.rameses.util.CloneHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class EntityUtil {
    public static Map fieldToMap(Map source) {
        return EntityUtil.fieldToMap(source, false);
    }

    public static Map fieldToMap(Map source, boolean prefixed) {
        Map.Entry me;
        LinkedHashMap target = new LinkedHashMap();
        LinkedHashMap embeddedFields = new LinkedHashMap();
        Iterator iterator = source.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            me = o = iterator.next();
            String key = me.getKey().toString();
            boolean _process = false;
            if (prefixed && key.startsWith(":")) {
                _process = true;
            } else if (key.indexOf("_") > 0 && !key.endsWith("_")) {
                _process = true;
            }
            if (_process) {
                if (key.startsWith(":")) {
                    key = key.substring(1);
                }
                String[] arr = key.split("_");
                LinkedHashMap c = embeddedFields;
                for (int i = 0; i < arr.length - 1; ++i) {
                    String kf = arr[i];
                    LinkedHashMap inner = (LinkedHashMap)c.get(kf);
                    if (inner == null) {
                        inner = new LinkedHashMap();
                        c.put(kf, inner);
                    }
                    c = inner;
                }
                String lastField = arr[arr.length - 1];
                c.put(lastField, me.getValue());
                continue;
            }
            target.put(me.getKey(), me.getValue());
        }
        for (Map.Entry m : embeddedFields.entrySet()) {
            me = m;
            target.put(me.getKey(), me.getValue());
        }
        return target;
    }

    public static Map mapToField(Map source) {
        return EntityUtil.mapToField(source, null, false);
    }

    public static Map mapToField(Map source, boolean includePrefix) {
        return EntityUtil.mapToField(source, null, includePrefix);
    }

    public static Map mapToField(Map source, String excludeFields) {
        return EntityUtil.mapToField(source, excludeFields, false);
    }

    private static void collectData(String parentField, String fieldName, Object d, Map target, boolean includePrefix) {
        if (d instanceof Map) {
            parentField = parentField == null ? fieldName : parentField + "_" + fieldName;
            Iterator iterator = ((Map)d).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry me = o = iterator.next();
                EntityUtil.collectData(parentField, me.getKey().toString(), me.getValue(), target, includePrefix);
            }
        } else {
            if (parentField != null) {
                fieldName = parentField + "_" + fieldName;
            }
            if (includePrefix) {
                fieldName = ":" + fieldName;
            }
            target.put(fieldName, d);
        }
    }

    public static Map mapToField(Map source, String excludeFields, boolean includePrefix) {
        LinkedHashMap target = new LinkedHashMap();
        Iterator iterator = source.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry me = o = iterator.next();
            if (excludeFields != null && me.getKey().toString().matches(excludeFields)) {
                target.put(me.getKey(), me.getValue());
                continue;
            }
            if (me.getValue() instanceof Map) {
                EntityUtil.collectData(null, me.getKey() + "", me.getValue(), target, includePrefix);
                continue;
            }
            target.put(me.getKey(), me.getValue());
        }
        return target;
    }

    public static boolean checkNestedValueExist(Map data, String name) throws Exception {
        if (name.indexOf("_") > 0) {
            if (data.containsKey(name)) {
                return true;
            }
            Map odata = data;
            String[] arr = name.split("_");
            for (int i = 0; i < arr.length - 1; ++i) {
                Object z = odata.get(arr[i]);
                if (z == null) {
                    return false;
                }
                if (!(z instanceof Map)) {
                    return false;
                }
                odata = (Map)z;
            }
            return true;
        }
        return data.containsKey(name);
    }

    public static Object getNestedValue(Map data, String name) throws Exception {
        if (name.indexOf("_") > 0) {
            if (data.containsKey(name)) {
                return data.get(name);
            }
            Map odata = data;
            String[] arr = name.split("_");
            for (int i = 0; i < arr.length - 1; ++i) {
                Object z = odata.get(arr[i]);
                if (z == null) {
                    return null;
                }
                if (!(z instanceof Map)) {
                    return z;
                }
                odata = (Map)z;
            }
            return odata.get(arr[arr.length - 1]);
        }
        return data.get(name);
    }

    public static Object putNestedValue(Map data, String name, Object value) throws Exception {
        if (name.indexOf("_") > 0) {
            if (data.containsKey(name)) {
                return data.put(name, value);
            }
            Map odata = data;
            String[] arr = name.split("_");
            for (int i = 0; i < arr.length - 1; ++i) {
                Object z = odata.get(arr[i]);
                if (z == null) {
                    z = new HashMap();
                    odata.put(arr[i], z);
                }
                if (!(z instanceof Map)) {
                    throw new Exception("Cannot cast to map ->" + name);
                }
                odata = (Map)z;
            }
            return odata.put(arr[arr.length - 1], value);
        }
        return data.put(name, value);
    }

    public static List getDataList(Map data, String name) throws Exception {
        ArrayList l = EntityUtil.getNestedValue(data, name);
        if (l != null && !(l instanceof List)) {
            throw new Exception("DataUtil.getDataList error. List " + name + " does not exist");
        }
        if (l == null) {
            l = new ArrayList();
        }
        return l;
    }

    public static Map clone(Map source, String fieldExpr) {
        return new CloneHelper().clone(source, fieldExpr);
    }
}

