/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import com.rameses.util.Base64Coder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Hashtable;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class Encoder {
    protected static final Map<String, Encoder> encoders = new Hashtable<String, Encoder>();
    public static MD5Encoder MD5;
    public static SHA1Encoder SHA1;

    public abstract String encode(String var1);

    public abstract String encode(String var1, String var2);

    public abstract String encode(String var1, String var2, int var3);

    public String toHexString(byte[] hash) {
        String hexDigit = "0123456789abcdef";
        StringBuffer sb = new StringBuffer(hash.length);
        for (int i = 0; i < hash.length; ++i) {
            int b = hash[i] & 0xFF;
            sb.append(hexDigit.charAt(b >>> 4));
            sb.append(hexDigit.charAt(b & 0xF));
        }
        return sb.toString();
    }

    public static synchronized Encoder get(String name) {
        if (name.equalsIgnoreCase("md5")) {
            return MD5;
        }
        if (name.equalsIgnoreCase("sha1")) {
            return SHA1;
        }
        return encoders.get(name);
    }

    static {
        encoders.put("base64", new Base64());
        encoders.put("sha256", new SHA256());
        MD5 = new MD5Encoder();
        SHA1 = new SHA1Encoder();
    }

    public static class SHA256
    extends Encoder {
        @Override
        public String toHexString(byte[] hash) {
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < hash.length; ++i) {
                String hex = Integer.toHexString(0xFF & hash[i]);
                if (hex.length() == 1) {
                    buff.append("0");
                }
                buff.append(hex);
            }
            return buff.toString();
        }

        @Override
        public String encode(String value) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                byte[] hash = md.digest(value.getBytes(StandardCharsets.UTF_8));
                return this.toHexString(hash);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }

        @Override
        public String encode(String value, String seed) {
            return this.encode(value, seed, 0);
        }

        @Override
        public String encode(String value, String seed, int caseType) {
            StringBuilder sb = new StringBuilder(value.toString());
            if (seed != null) {
                sb.append(seed);
            }
            if (caseType == 1) {
                return this.encode(sb.toString().toLowerCase());
            }
            if (caseType == 2) {
                return this.encode(sb.toString().toUpperCase());
            }
            return this.encode(sb.toString());
        }
    }

    public static class Base64
    extends Encoder {
        private Base64Coder coder;

        private Base64Coder getCoder() {
            if (this.coder == null) {
                this.coder = new Base64Coder();
            }
            return this.coder;
        }

        @Override
        public String encode(String value) {
            try {
                this.getCoder();
                return Base64Coder.encodeString(value);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        @Override
        public String encode(String value, String seed) {
            return this.encode(value, seed, 1);
        }

        @Override
        public String encode(String value, String seed, int caseType) {
            return this.encode(value);
        }
    }

    public static class SHA1Encoder
    extends Encoder {
        @Override
        public String encode(String value) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA1");
                md.update(value.getBytes());
                byte[] hash = md.digest();
                return this.toHexString(hash);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        @Override
        public String encode(String v, String seed) {
            return this.encode(v, seed, 1);
        }

        @Override
        public String encode(String v, String seed, int caseType) {
            try {
                if (caseType == 1) {
                    seed = seed.toLowerCase();
                } else if (caseType == 2) {
                    seed = seed.toUpperCase();
                }
                SecretKeySpec skey = new SecretKeySpec(seed.getBytes(), "HmacSHA1");
                Mac mac = Mac.getInstance("HmacSHA1");
                mac.init(skey);
                byte[] hash = mac.doFinal(v.getBytes());
                return this.toHexString(hash);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public static class MD5Encoder
    extends Encoder {
        @Override
        public String encode(String value) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(value.getBytes());
                byte[] hash = md.digest();
                return this.toHexString(hash);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        @Override
        public String encode(String v, String seed) {
            return this.encode(v, seed, 1);
        }

        @Override
        public String encode(String v, String seed, int caseType) {
            try {
                if (caseType == 1) {
                    seed = seed.toLowerCase();
                } else if (caseType == 2) {
                    seed = seed.toUpperCase();
                }
                SecretKeySpec skey = new SecretKeySpec(seed.getBytes(), "HmacMD5");
                Mac mac = Mac.getInstance("HmacMD5");
                mac.init(skey);
                byte[] hash = mac.doFinal(v.getBytes());
                return this.toHexString(hash);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

