/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import com.rameses.util.HolidayProvider;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class DefaultHolidayProvider
implements HolidayProvider {
    private HolidayProvider holidayProvider;
    private List<Date> holidays = new LinkedList<Date>();
    private List<Date> nonholidays = new LinkedList<Date>();

    public HolidayProvider getHolidayProvider() {
        return this.holidayProvider;
    }

    public void setHolidayProvider(HolidayProvider holidayProvider) {
        this.holidayProvider = holidayProvider;
    }

    @Override
    public final boolean exists(Date date) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            date = sdf.parse(sdf.format(date));
        }
        catch (Exception sdf) {
            // empty catch block
        }
        if (this.holidays.contains(date)) {
            return true;
        }
        if (this.nonholidays.contains(date)) {
            return false;
        }
        boolean b = this.isHoliday(date);
        if (b) {
            this.holidays.add(date);
            return true;
        }
        this.nonholidays.add(date);
        return false;
    }

    public boolean isHoliday(Date date) {
        if (this.holidayProvider == null) {
            throw new RuntimeException("CachedHolidayProvider.error. HolidayProvider must not be null");
        }
        return this.holidayProvider.exists(date);
    }
}

