/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import com.rameses.util.Base64Cipher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AESCipher {
    private static final String CIPHER_FORM = "AES/CBC/PKCS5Padding";
    private String secretKey;

    public AESCipher() {
        this("qajzMGqqrOQAnGleiknCXQ==");
    }

    public AESCipher(String secretKey) {
        this.secretKey = secretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encode(Object data) throws Exception {
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(data);
            String string = this.encode(baos.toByteArray());
            return string;
        }
        finally {
            try {
                oos.close();
            }
            catch (Throwable throwable) {}
            try {
                baos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public String encode(String data) throws Exception {
        return this.encode(data.getBytes(StandardCharsets.UTF_8));
    }

    public String encode(byte[] bytes) throws Exception {
        SecretKeySpec skSpec = this.generateKey();
        IvParameterSpec ivSpec = new IvParameterSpec(new byte[16]);
        Cipher cipher = Cipher.getInstance(CIPHER_FORM);
        cipher.init(1, (Key)skSpec, ivSpec);
        byte[] enc_bytes = cipher.doFinal(bytes);
        return new Base64Cipher().encode(enc_bytes);
    }

    public byte[] decode(String encstr) throws Exception {
        char[] enc_chars = encstr.toCharArray();
        byte[] dec_bytes = new Base64Cipher().decode(enc_chars, 0, enc_chars.length);
        SecretKeySpec skSpec = this.generateKey();
        IvParameterSpec ivSpec = new IvParameterSpec(new byte[16]);
        Cipher cipher = Cipher.getInstance(CIPHER_FORM);
        cipher.init(2, (Key)skSpec, ivSpec);
        return cipher.doFinal(dec_bytes);
    }

    public String decodeString(String encstr) throws Exception {
        byte[] bytes = this.decode(encstr);
        return new String(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decodeObject(String encstr) throws Exception {
        byte[] bytes = this.decode(encstr);
        ObjectInputStream ois = null;
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            return object;
        }
        finally {
            try {
                ois.close();
            }
            catch (Throwable throwable) {}
            try {
                bais.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private SecretKeySpec generateKey() throws Exception {
        byte[] bytes = this.secretKey.getBytes(StandardCharsets.UTF_8);
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] hash = md.digest(bytes);
        bytes = new byte[16];
        System.arraycopy(hash, 0, bytes, 0, 16);
        return new SecretKeySpec(bytes, "AES");
    }
}

