/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.service;

import com.rameses.common.AsyncHandler;
import com.rameses.service.AsyncTask;
import com.rameses.service.ServiceProxy;
import com.rameses.util.AppException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ServiceProxyInvocationHandler
implements InvocationHandler {
    private static final ExecutorService thread = Executors.newFixedThreadPool(10);
    private ServiceProxy proxy;
    private boolean failOnConnectionError;

    public ServiceProxyInvocationHandler(ServiceProxy proxy) {
        this(proxy, true);
    }

    public ServiceProxyInvocationHandler(ServiceProxy proxy, boolean failOnConnectionError) {
        this.proxy = proxy;
        this.failOnConnectionError = failOnConnectionError;
    }

    public Object invokeMethod(String methodName, Object[] args) throws Throwable {
        if (methodName.equals("toString")) {
            return this.proxy.getClass().getName();
        }
        try {
            if (args == null || args.length == 0) {
                return this.proxy.invoke(methodName);
            }
            AsyncHandler handler = null;
            if (args[args.length - 1] instanceof AsyncHandler) {
                Object[] newArgs = new Object[args.length - 1];
                for (int i = 0; i < newArgs.length; ++i) {
                    newArgs[i] = args[i];
                }
                handler = (AsyncHandler)args[args.length - 1];
                args = newArgs;
            }
            if (handler != null) {
                thread.submit(new AsyncTask(this.proxy, methodName, args, handler));
                return null;
            }
            return this.proxy.invoke(methodName, args);
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (this.isConnectionError(t) && !this.failOnConnectionError) {
                return null;
            }
            if (t instanceof AppException) {
                throw t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t.getMessage(), t);
        }
    }

    @Override
    public Object invoke(Object sproxy, Method method, Object[] args) throws Throwable {
        return this.invokeMethod(method.getName(), args);
    }

    private boolean isConnectionError(Throwable e) {
        if (e instanceof ConnectException) {
            return true;
        }
        if (e instanceof SocketException) {
            return true;
        }
        if (e instanceof SocketTimeoutException) {
            return true;
        }
        if (e instanceof UnknownHostException) {
            return true;
        }
        if (e instanceof MalformedURLException) {
            return true;
        }
        if (e instanceof ProtocolException) {
            return true;
        }
        return e instanceof UnknownServiceException;
    }
}

