/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.service;

import com.rameses.common.AbstractAsyncHandler;
import com.rameses.common.AsyncBatchResult;
import com.rameses.common.AsyncException;
import com.rameses.common.AsyncHandler;
import com.rameses.common.AsyncToken;
import com.rameses.service.AsyncPoller;
import com.rameses.service.ServiceProxy;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AsyncTask
implements Runnable {
    private ServiceProxy proxy;
    private String methodName;
    private Object[] args;
    private AsyncHandlerProxy handlerProxy;
    private AsyncPoller poller;
    private int retrycount;
    private final LinkedBlockingQueue WAIT_LOCKER = new LinkedBlockingQueue();

    public AsyncTask(ServiceProxy proxy, String methodName, Object[] args, AsyncHandler handler) {
        this.proxy = proxy;
        this.methodName = methodName;
        this.args = args;
        this.handlerProxy = new AsyncHandlerProxy(handler);
    }

    @Override
    public void run() {
        try {
            this.retrycount = 0;
            Object result = this.invoke();
            if (result instanceof AsyncToken) {
                AsyncToken token = (AsyncToken)result;
                if (token.isClosed()) {
                    this.fireOnMessage(-1);
                    return;
                }
                AsyncPoller poller = new AsyncPoller(this.proxy.getConf(), token);
                this.handle(poller);
                return;
            }
            this.notify(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handlerProxy.onError(e);
        }
    }

    private Object invoke() {
        Exception err = null;
        int retrycount = 0;
        while (retrycount < 3) {
            try {
                ++retrycount;
                return this.proxy.invoke(this.methodName, this.args);
            }
            catch (Exception e) {
                System.err.println(e.getClass().getName() + ": " + e.getMessage());
                err = e;
            }
            catch (Throwable t) {
                System.err.println(t.getClass().getName() + ": " + t.getMessage());
                err = new Exception(t.getMessage(), t);
            }
        }
        if (err != null) {
            this.handlerProxy.onError(err);
        }
        return null;
    }

    private Object fetchResult(AsyncPoller poller, int retryLimit) {
        int maxRetryLimit;
        int retrycount = 0;
        int n = maxRetryLimit = retryLimit > 0 ? retryLimit : 1;
        while (retrycount < maxRetryLimit) {
            try {
                ++retrycount;
                return poller.poll();
            }
            catch (Exception e) {
                System.err.println(e.getClass().getName() + ": " + e.getMessage());
            }
            catch (Throwable t) {
                System.err.println(t.getClass().getName() + ": " + t.getMessage());
            }
            try {
                this.WAIT_LOCKER.poll(1000L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable throwable) {}
        }
        return new RetryFailedException();
    }

    private boolean fireOnMessage(Object data) {
        if (this.handlerProxy.isCancelRequested()) {
            try {
                this.handlerProxy.onCancel();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                return false;
            }
        }
        this.handlerProxy.onMessage(data);
        return true;
    }

    private void handle(AsyncPoller poller) throws Exception {
        if (this.handlerProxy.isCancelRequested()) {
            try {
                try {
                    this.handlerProxy.onCancel();
                    return;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    return;
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }
        Object result = this.fetchResult(poller, 3);
        if (result == null || result instanceof RetryFailedException) {
            this.handlerProxy.onTimeout("poll failed after 3 retries");
            if (this.handlerProxy.isRetryRequested()) {
                this.handle(poller);
            }
            return;
        }
        if (result instanceof AsyncToken) {
            AsyncToken at = (AsyncToken)result;
            if (at.isClosed()) {
                poller.close();
                this.fireOnMessage(-1);
                return;
            }
        } else if (this.notify(result)) {
            this.handle(poller);
        } else {
            poller.close();
            this.handlerProxy.onMessage(-1);
        }
    }

    private boolean notify(Object o) {
        if (o instanceof AsyncException) {
            this.handlerProxy.onError((AsyncException)o);
            return false;
        }
        if (o instanceof AsyncBatchResult) {
            boolean is_closed = false;
            AsyncBatchResult batch = (AsyncBatchResult)o;
            for (Object item : batch) {
                if (item instanceof AsyncToken) {
                    is_closed = ((AsyncToken)item).isClosed();
                    continue;
                }
                if (item instanceof AsyncException) {
                    this.handlerProxy.onError((AsyncException)item);
                    return false;
                }
                this.fireOnMessage(item);
            }
            return !is_closed;
        }
        return this.fireOnMessage(o);
    }

    private class AsyncHandlerProxy
    extends AbstractAsyncHandler {
        private AsyncHandler source;

        AsyncHandlerProxy(AsyncHandler source) {
            this.source = source;
            if (source == null) {
                this.source = new AsyncHandler(){

                    @Override
                    public void onMessage(Object value) {
                        System.out.println("unhandled message. No handler passed ");
                    }

                    @Override
                    public void onError(Exception e) {
                        e.printStackTrace();
                    }

                    @Override
                    public void call(Object o) {
                    }
                };
            }
        }

        @Override
        public void onError(Exception e) {
            if (this.source != null) {
                this.source.onError(e);
            }
        }

        @Override
        public void onMessage(Object o) {
            if (this.source != null) {
                this.source.onMessage(o);
            }
        }

        @Override
        public void call(Object o) {
            if (this.source != null) {
                this.source.call(o);
            }
        }

        public void onTimeout(String msg) {
            if (this.source instanceof AbstractAsyncHandler) {
                ((AbstractAsyncHandler)this.source).onTimeout();
            } else if (this.source != null) {
                this.source.onError(new TimeoutException(msg));
            }
        }

        @Override
        public void onCancel() {
            if (this.source instanceof AbstractAsyncHandler) {
                ((AbstractAsyncHandler)this.source).onCancel();
            }
        }

        public boolean isRetryRequested() {
            if (this.source instanceof AbstractAsyncHandler) {
                return ((AbstractAsyncHandler)this.source).hasRequestRetry();
            }
            return false;
        }

        public boolean isCancelRequested() {
            if (this.source instanceof AbstractAsyncHandler) {
                return ((AbstractAsyncHandler)this.source).hasRequestCancel();
            }
            return false;
        }
    }

    private class RetryFailedException
    extends Exception {
        private RetryFailedException() {
        }
    }
}

