/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.service;

import com.rameses.http.HttpClient;
import java.util.Map;

public abstract class AbstractServiceProxy {
    protected HttpClient client;
    protected String serviceName;
    protected Map conf;

    public AbstractServiceProxy(String serviceName, Map conf) {
        String appContext = (String)conf.get("app.context");
        String host = (String)conf.get("app.host");
        if (host == null) {
            host = "localhost:8080";
        }
        this.client = new HttpClient(host, true);
        this.serviceName = serviceName;
        this.conf = conf;
        Number num = this.getNumber(conf, "readTimeout");
        if (num != null) {
            this.client.setReadTimeout(num.intValue());
        }
        if ((num = this.getNumber(conf, "connectionTimeout")) != null) {
            this.client.setConnectionTimeout(num.intValue());
        }
        try {
            this.client.setProtocol(conf.get("protocol").toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.client.setDebug("true".equalsIgnoreCase(conf.get("debug").toString()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            boolean bool = "true".equals(conf.get("encrypted").toString());
            this.client.setEncrypted(bool);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Map getConf() {
        return this.conf;
    }

    private Number getNumber(Map map, Object key) {
        Object value;
        Object object = value = map == null ? null : (Object)map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        try {
            return new Integer(value.toString());
        }
        catch (Throwable t) {
            return null;
        }
    }
}

