/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;

public class IOStream {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public void write(byte[] bytes, File file) {
        try {
            this.write(bytes, new FileOutputStream(file));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void write(byte[] bytes, OutputStream output) {
        this.write(bytes, output, 4096);
    }

    public void write(byte[] bytes, OutputStream output, int bufferSize) {
        IOStream.write(new ByteArrayInputStream(bytes), output, bufferSize);
    }

    public static void write(URL url, OutputStream output) {
        try {
            if (url == null) {
                return;
            }
            IOStream.write(url.openStream(), output);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void write(InputStream input, OutputStream output) {
        IOStream.write(input, output, 4096);
    }

    public static void write(InputStream input, OutputStream output, int bufferSize) {
        try {
            byte[] buffer = new byte[bufferSize];
            int EOF = -1;
            int len = 0;
            while ((len = input.read(buffer)) != EOF) {
                output.write(buffer, 0, len);
            }
            output.flush();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        finally {
            try {
                output.close();
            }
            catch (Exception exception) {}
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }

    public static byte[] toByteArray(File file) {
        try {
            return IOStream.toByteArray(new FileInputStream(file), 4096);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static byte[] toByteArray(URL url) {
        try {
            if (url == null) {
                return null;
            }
            InputStream inp = url.openStream();
            return IOStream.toByteArray(inp, 4096);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static byte[] toByteArray(InputStream input) {
        return IOStream.toByteArray(input, 4096);
    }

    public static byte[] toByteArray(InputStream input, int bufferSize) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOStream.write(input, output, bufferSize);
        return output.toByteArray();
    }

    public static byte[] toByteArray(Object value) {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        try {
            byte[] bytes;
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            byte[] byArray = bytes = baos.toByteArray();
            return byArray;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                oos.close();
            }
            catch (Throwable throwable) {}
            try {
                baos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public Object readObject(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        try {
            Object o;
            bais = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bais);
            Object object = o = ois.readObject();
            return object;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                ois.close();
            }
            catch (Throwable throwable) {}
            try {
                bais.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

