/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FileUtil {
    public static Object readObject(File f) {
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(f);
            ois = new ObjectInputStream(fis);
            Object object = ois.readObject();
            return object;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception exception) {}
            try {
                ois.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void writeObject(File f, Object o) {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            if (f.getParentFile() != null && !f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            if (!f.exists()) {
                f.createNewFile();
            }
            fos = new FileOutputStream(f);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(o);
            oos.flush();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception exception) {}
            try {
                oos.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void writeBytes(File f, byte[] bytes) {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            if (f.getParentFile() != null && !f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            if (!f.exists()) {
                f.createNewFile();
            }
            fos = new FileOutputStream(f);
            fos.write(bytes);
            fos.flush();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception exception) {}
            try {
                oos.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void extractStringFromFile(String pattern, StringBuffer sout, FileInputStream input) throws Exception {
        FileChannel channel = input.getChannel();
        int fileLength = (int)channel.size();
        MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, fileLength);
        Charset charset = Charset.forName("ISO-8859-1");
        CharsetDecoder decoder = charset.newDecoder();
        CharBuffer charBuffer = decoder.decode(buffer);
        Pattern p = Pattern.compile(pattern);
        Matcher matcher = p.matcher(charBuffer);
        int start = 0;
        int end = 0;
        boolean started = false;
        while (matcher.find()) {
            if (!started) {
                started = true;
                start = matcher.end();
                continue;
            }
            end = matcher.start();
            break;
        }
        sout.append(charBuffer.subSequence(start, end));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, File dest) {
        FilterOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            if (dest.isDirectory()) {
                dest = new File(dest, source.getName());
            }
            bos = new BufferedOutputStream(new FileOutputStream(dest));
            bis = new BufferedInputStream(new FileInputStream(source));
            byte[] buff = new byte[10240];
            int bytesRead = -1;
            while ((bytesRead = bis.read(buff)) != -1) {
                ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
            }
            ((BufferedOutputStream)bos).flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                bos.close();
            }
            catch (Exception exception) {}
            try {
                bis.close();
            }
            catch (Exception exception) {}
        }
    }

    public static boolean deleteRecursive(File path) {
        if (!path.exists()) {
            return false;
        }
        if (path.isDirectory()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileUtil.deleteRecursive(files[i]);
            }
        }
        return path.delete();
    }
}

