/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.server.UID;
import java.util.Date;

public class FileTransferInfo
implements Serializable {
    private String tempId;
    private String name;
    private String path;
    private long lastModified;
    private long dtstarted;
    private String fileExt;
    private long size;
    private long bytesRead;
    private boolean eof;
    private String tempFileName;

    public FileTransferInfo(File f) {
        this.name = f.getName();
        int idx = this.name.indexOf(".");
        if (idx > 0) {
            this.fileExt = this.name.substring(idx + 1);
        }
        this.tempId = "F" + new UID() + (this.fileExt != null ? "" : "." + this.fileExt);
        this.path = f.getPath();
        this.size = f.length();
        this.lastModified = f.lastModified();
        this.dtstarted = new Date().getTime();
    }

    public String getTempId() {
        return this.tempId;
    }

    public String getName() {
        return this.name;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getFileExt() {
        return this.fileExt;
    }

    public long getSize() {
        return this.size;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public void setBytesRead(long bytesRead) {
        this.bytesRead = bytesRead;
    }

    public String getPath() {
        return this.path;
    }

    public String getFileId() {
        return this.tempId + "." + this.fileExt;
    }

    public long getDtstarted() {
        return this.dtstarted;
    }

    public boolean isEof() {
        return this.eof;
    }

    public void setEof(boolean eof) {
        this.eof = eof;
    }

    public void save() throws Exception {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(this.tempFileName);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(this);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception exception) {}
            try {
                fos.close();
            }
            catch (Exception exception) {}
        }
    }

    public String getTempFileName() {
        return this.tempFileName;
    }

    public void setTempFileName(String tempFileName) {
        this.tempFileName = tempFileName;
    }

    public void delete() {
        File f = new File(this.tempFileName);
        if (f.exists()) {
            f.delete();
        }
    }
}

