/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.io;

import com.rameses.io.AbstractChunkHandler;
import com.rameses.io.ChunkHandler;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.rmi.server.UID;
import java.util.Map;

public class FileObject {
    public static final int CHUNK_SIZE = 65536;
    public static final int MIN_CHUNK_SIZE = 32000;
    private File file;
    private Map info;
    private int chunkSize;
    private int pos;

    public FileObject(File file) {
        this(file, 65536);
    }

    public FileObject(File file, int chunkSize) {
        this.file = file;
        this.chunkSize = chunkSize;
    }

    public File getFile() {
        return this.file;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public void read(ChunkHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Please specify a ChunkHandler before reading the file ");
        }
        AbstractChunkHandler proxy = null;
        proxy = handler instanceof AbstractChunkHandler ? (AbstractChunkHandler)handler : new ChunkHandlerProxy(handler);
        MetaInfo meta = new MetaInfo();
        meta.id = "FO" + new UID();
        meta.file = this.file;
        try {
            URLConnection urlconn = meta.file.toURL().openConnection();
            meta.fileType = urlconn.getContentType();
            meta.fileName = this.file.getName();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (proxy.isAutoComputeTotals()) {
            meta.autoComputeTotals = true;
            this.chunk(proxy, meta, true);
        }
        proxy.setMeta(meta);
        proxy.start();
        if (!proxy.isCancelled()) {
            this.chunk(proxy, meta, false);
        }
        proxy.end();
    }

    private void chunk(AbstractChunkHandler handler, MetaInfo meta, boolean bypassHandler) {
        int size = this.getChunkSize();
        if (size < 32000) {
            throw new IllegalStateException("The minimum chunk size is 32kb");
        }
        ByteBuffer buf = ByteBuffer.allocate(size);
        RandomAccessFile raf = null;
        AbstractInterruptibleChannel channel = null;
        try {
            int startPos;
            raf = new RandomAccessFile(this.file, "r");
            channel = raf.getChannel();
            if (bypassHandler) {
                meta.fileSize = ((FileChannel)channel).size();
                long num = meta.fileSize / (long)size;
                if (meta.fileSize % (long)size > 0L) {
                    ++num;
                }
                meta.chunkCount = (int)num;
                return;
            }
            byte[] bytes = null;
            int read = 0;
            int indexno = 0;
            int n = startPos = this.pos > 0 ? this.pos : 1;
            while ((read = ((FileChannel)channel).read(buf)) > 0) {
                buf.flip();
                bytes = new byte[read];
                System.arraycopy(buf.array(), 0, bytes, 0, read);
                buf.clear();
                ++indexno;
                if (!meta.autoComputeTotals) {
                    meta.chunkCount = indexno;
                    MetaInfo metaInfo = meta;
                    metaInfo.fileSize = metaInfo.fileSize + (long)read;
                }
                if (indexno >= startPos) {
                    handler.handle(indexno, bytes);
                }
                if (!handler.isCancelled()) continue;
                break;
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                buf.clear();
            }
            catch (Throwable throwable) {}
            try {
                channel.close();
            }
            catch (Throwable throwable) {}
            try {
                raf.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private class ChunkHandlerProxy
    extends AbstractChunkHandler {
        private ChunkHandler handler;

        ChunkHandlerProxy(ChunkHandler handler) {
            this.handler = handler;
        }

        @Override
        public void start() {
            this.handler.start();
        }

        @Override
        public void end() {
            this.handler.end();
        }

        @Override
        public void handle(int indexno, byte[] bytes) {
            this.handler.handle(indexno, bytes);
        }
    }

    public class MetaInfo {
        private boolean autoComputeTotals;
        private File file;
        private String id;
        private String fileName;
        private String fileType;
        private long fileSize;
        private int chunkCount;

        public String getId() {
            return this.id;
        }

        public File getFile() {
            return this.file;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFileType() {
            return this.fileType;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public int getChunkCount() {
            return this.chunkCount;
        }
    }
}

