/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.io;

import com.rameses.io.AbstractChunkHandler;
import com.rameses.io.ChunkHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;

public class FileChunker {
    private int chunkSize = 32000;
    private Parser parser = null;
    private int pos;

    public FileChunker(File file) {
        this.parser = new FileParser(file);
    }

    public FileChunker(byte[] bytes, String name, String type) {
        this.parser = new ByteParser(bytes, null, null);
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public String getName() {
        return this.parser.getName();
    }

    public String getType() {
        return this.parser.getType();
    }

    public long getLength() {
        return this.parser.getLength();
    }

    public int getCount() {
        long len = this.getLength();
        long count = len / (long)this.getChunkSize();
        if (len % (long)this.getChunkSize() > 0L) {
            ++count;
        }
        return (int)count;
    }

    public List<byte[]> getChunks() {
        ChunkHandlerImpl handler = new ChunkHandlerImpl();
        this.parse(handler);
        return handler.results;
    }

    public void parse() {
        this.parse(new SelfChunkHandler());
    }

    public void parse(ChunkHandler handler) {
        this.parser.parse(handler);
    }

    protected void onstart() {
    }

    protected void onend() {
    }

    protected void onhandle(int indexno, byte[] bytes) {
    }

    protected void onerror(Throwable error) {
        error.printStackTrace();
    }

    private class ByteParser
    implements Parser {
        byte[] bytes;
        String name;
        String type;

        ByteParser(byte[] bytes, String name, String type) {
            this.bytes = bytes;
            this.name = name;
            this.type = type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public long getLength() {
            return this.bytes.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(ChunkHandler handler) {
            boolean started = false;
            Throwable error = null;
            FileChunker root = FileChunker.this;
            ByteArrayInputStream bais = null;
            BufferedInputStream bis = null;
            try {
                bais = new ByteArrayInputStream(this.bytes);
                bis = new BufferedInputStream(bais);
                root.onstart();
                handler.start();
                started = true;
                int counter = 1;
                int read = -1;
                byte[] chunks = new byte[FileChunker.this.getChunkSize()];
                while ((read = bis.read(chunks)) != -1) {
                    if (read < chunks.length) {
                        byte[] dest = new byte[read];
                        System.arraycopy(chunks, 0, dest, 0, read);
                        handler.handle(counter, dest);
                        root.onhandle(counter, dest);
                    } else {
                        handler.handle(counter, chunks);
                        root.onhandle(counter, chunks);
                    }
                    chunks = new byte[FileChunker.this.getChunkSize()];
                    ++counter;
                }
            }
            catch (Throwable t) {
                error = t;
            }
            finally {
                try {
                    bis.close();
                }
                catch (Throwable counter) {}
                try {
                    bais.close();
                }
                catch (Throwable counter) {}
            }
            if (error != null) {
                root.onerror(error);
            } else if (started) {
                handler.end();
                root.onend();
            }
        }
    }

    private class FileParser
    implements Parser {
        File file;

        FileParser(File file) {
            this.file = file;
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public String getType() {
            try {
                URLConnection urlconn = this.file.toURL().openConnection();
                return urlconn.getContentType();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public long getLength() {
            RandomAccessFile raf = null;
            AbstractInterruptibleChannel fc = null;
            Object bytes = null;
            try {
                raf = new RandomAccessFile(this.file, "r");
                fc = raf.getChannel();
                long l = ((FileChannel)fc).size();
                return l;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                try {
                    fc.close();
                }
                catch (Throwable throwable) {}
                try {
                    raf.close();
                }
                catch (Throwable throwable) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(ChunkHandler handler) {
            FileChunker root = FileChunker.this;
            int chunkPos = root.pos;
            if (chunkPos <= 0) {
                chunkPos = 1;
            }
            boolean started = false;
            Throwable error = null;
            RandomAccessFile raf = null;
            AbstractInterruptibleChannel fc = null;
            try {
                raf = new RandomAccessFile(this.file, "r");
                raf.seek((chunkPos - 1) * FileChunker.this.getChunkSize());
                fc = raf.getChannel();
                root.onstart();
                handler.start();
                started = true;
                int counter = chunkPos;
                int bytesRead = -1;
                ByteBuffer buffer = ByteBuffer.allocate(FileChunker.this.getChunkSize());
                while ((bytesRead = ((FileChannel)fc).read(buffer)) != -1) {
                    buffer.flip();
                    if (buffer.hasRemaining()) {
                        byte[] chunks = buffer.array();
                        if (bytesRead < chunks.length) {
                            byte[] dest = new byte[bytesRead];
                            System.arraycopy(chunks, 0, dest, 0, bytesRead);
                            handler.handle(counter, dest);
                            root.onhandle(counter, dest);
                        } else {
                            handler.handle(counter, chunks);
                            root.onhandle(counter, chunks);
                        }
                        ++counter;
                    }
                    buffer.clear();
                }
            }
            catch (Throwable t) {
                error = t;
            }
            finally {
                try {
                    fc.close();
                }
                catch (Throwable counter) {}
                try {
                    raf.close();
                }
                catch (Throwable counter) {}
            }
            if (error != null) {
                root.onerror(error);
            } else if (started) {
                handler.end();
                root.onend();
            }
        }
    }

    private static interface Parser {
        public String getName();

        public String getType();

        public long getLength();

        public void parse(ChunkHandler var1);
    }

    private class ChunkHandlerImpl
    extends AbstractChunkHandler {
        List<byte[]> results = new ArrayList<byte[]>();

        private ChunkHandlerImpl() {
        }

        @Override
        public void start() {
            this.results.clear();
        }

        @Override
        public void end() {
        }

        @Override
        public void handle(int indexno, byte[] bytes) {
            this.results.add(bytes);
        }
    }

    private class SelfChunkHandler
    extends AbstractChunkHandler {
        private SelfChunkHandler() {
        }

        @Override
        public void start() {
        }

        @Override
        public void end() {
        }

        @Override
        public void handle(int indexno, byte[] bytes) {
        }
    }
}

