/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.http;

import com.rameses.http.AllConnectionFailed;
import com.rameses.http.HttpClientOutputHandler;
import com.rameses.http.HttpClientUtils;
import com.rameses.http.ResponseError;
import com.rameses.http.StringHttpClientOutputHandler;
import com.rameses.util.SealedMessage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpClient
implements Serializable {
    public static HttpClientOutputHandler STRING_OUTPUT = new StringHttpClientOutputHandler();
    private boolean debug;
    private int readTimeout = 30000;
    private int connectionTimeout = 5000;
    private String protocol = "http";
    private HttpClientOutputHandler outputHandler;
    private boolean postAsObject = false;
    private String[] hosts;
    private boolean encrypted = true;
    private String contentType;
    private SSLSocketFactory sslSocketFactory;

    public HttpClient(String host) {
        this(host, false);
    }

    public HttpClient(String host, boolean postAsObject) {
        this.hosts = host.split(";");
        this.postAsObject = postAsObject;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setOutputHandler(HttpClientOutputHandler h) {
        this.outputHandler = h;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Object get() throws Exception {
        return this.get(null, null);
    }

    public Object get(String path) throws Exception {
        return this.get(path, null);
    }

    public Object get(String path, Map params) throws Exception {
        return this.get(path, params, null);
    }

    public Object get(String path, Map params, Map props) throws Exception {
        String parms = "";
        if (params != null) {
            parms = "?" + HttpClientUtils.stringifyParameters(params);
        }
        LinkedList<String> list = new LinkedList<String>();
        for (String s : this.hosts) {
            String p = path != null && path.trim().length() > 0 ? "/" + path : "";
            list.add(this.protocol + "://" + s + p + parms);
        }
        return this.invoke(list, null, "GET", props);
    }

    public Object post(Map params) throws Exception {
        return this.post(null, params);
    }

    public Object post(String path) throws Exception {
        return this.post(path, null);
    }

    public Object post(String path, Object args) throws Exception {
        return this.post(path, args, null);
    }

    public Object post(String path, Object args, Map props) throws Exception {
        LinkedList<String> list = new LinkedList<String>();
        for (String s : this.hosts) {
            String p = path != null && path.trim().length() > 0 ? "/" + path : "";
            list.add(this.protocol + "://" + s + p);
        }
        if (!this.postAsObject && args instanceof Map) {
            args = HttpClientUtils.stringifyParameters((Map)args);
        }
        return this.invoke(list, args, "POST", props);
    }

    private Object invoke(Queue<String> queue, Object parms, String methodType, Map props) throws Exception {
        try {
            return this.invokeImpl(queue, parms, methodType, props);
        }
        catch (Exception ex) {
            if (ex instanceof UnknownHostException || ex instanceof SocketException || ex instanceof ConnectException || ex instanceof SocketTimeoutException) {
                try {
                    return this.invokeImpl(queue, parms, methodType, props);
                }
                catch (AllConnectionFailed ae) {
                    throw ex;
                }
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeImpl(Queue<String> queue, Object parms, String methodType, Map props) throws Exception {
        HttpURLConnection conn = null;
        InputStream is = null;
        ObjectInputStream in = null;
        ObjectOutputStream out = null;
        String uhost = null;
        URL url = null;
        try {
            String ctype;
            boolean _asObject;
            uhost = queue.poll();
            if (uhost == null) {
                throw new AllConnectionFailed("Cannot connect to " + uhost);
            }
            url = new URL(uhost);
            conn = (HttpURLConnection)url.openConnection();
            if (conn instanceof HttpsURLConnection) {
                HttpsURLConnection httpsc = (HttpsURLConnection)conn;
                this.bypassSSLSecurityCheck(httpsc);
            }
            conn.setRequestMethod(methodType);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            if (this.readTimeout > 0) {
                conn.setReadTimeout(this.readTimeout);
            }
            if (this.connectionTimeout > 0) {
                conn.setConnectTimeout(this.connectionTimeout);
            }
            if (!(_asObject = this.postAsObject) && parms == null) {
                _asObject = true;
            }
            if (!_asObject && !(parms instanceof String)) {
                _asObject = true;
            }
            if (this.isDebug()) {
                System.out.format("[HttpClient.invoke] Host=%s, Type=%s, ConnTimeout=%d, ReadTimeout=%d, PostAsObject=%s%n", uhost, methodType, this.connectionTimeout, this.readTimeout, _asObject);
            }
            if (_asObject && !methodType.equalsIgnoreCase("GET")) {
                conn.setRequestProperty("CONTENT-TYPE", "application/osiris2-format");
                out = new ObjectOutputStream(conn.getOutputStream());
                if (this.encrypted && !(parms instanceof SealedMessage)) {
                    parms = new SealedMessage(parms);
                }
                if (parms != null) {
                    out.writeObject(parms);
                }
                out.flush();
            } else if (methodType.equalsIgnoreCase("POST")) {
                ctype = this.getContentType();
                if (ctype == null || ctype.length() == 0) {
                    ctype = "application/x-www-form-urlencoded";
                }
                conn.setRequestProperty("CONTENT-TYPE", ctype);
                this.addRequestProperties(conn, props);
                this.postString(conn, (String)parms);
            } else {
                ctype = this.getContentType();
                if (ctype == null || ctype.length() == 0) {
                    ctype = "application/x-www-form-urlencoded";
                }
                conn.setRequestProperty("CONTENT-TYPE", ctype);
                this.addRequestProperties(conn, props);
            }
            try {
                is = conn.getInputStream();
            }
            catch (Throwable t) {
                is = conn.getErrorStream();
                if (is != null) {
                    Exception orig = null;
                    String errMsg = conn.getHeaderField("Error-Message");
                    if (errMsg != null) {
                        orig = new Exception(errMsg);
                    } else {
                        errMsg = this.getErrorMessage(is);
                    }
                    if (this.isDebug()) {
                        System.out.println("Response Code: " + conn.getResponseCode() + " (" + conn.getResponseMessage() + ")");
                        System.out.println("Error-Message -> " + errMsg);
                    }
                    throw new ResponseError(conn.getResponseCode(), conn.getResponseMessage(), orig);
                }
                if (t instanceof SocketTimeoutException) {
                    System.err.println("SocketTimeoutException => " + url);
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw (Exception)t;
            }
            if (this.outputHandler == null) {
                Object retval = null;
                if (is != null) {
                    String t = conn.getContentType();
                    if (t != null && (t.startsWith("text") || t.indexOf("json") > 0)) {
                        StringBuilder b = new StringBuilder();
                        int i = 0;
                        while ((i = is.read()) != -1) {
                            b.append((char)i);
                        }
                        retval = b.toString();
                    } else {
                        try {
                            in = new ObjectInputStream(is);
                            retval = in.readObject();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                if (retval != null && retval instanceof SealedMessage) {
                    SealedMessage sm = (SealedMessage)retval;
                    retval = sm.getMessage();
                }
                if (retval != null) {
                    if (retval instanceof String && retval.equals("#NULL")) {
                        retval = null;
                    } else if (retval instanceof Exception) {
                        throw (Exception)retval;
                    }
                }
                Object object = retval;
                return object;
            }
            Object object = this.outputHandler.getResult(is);
            return object;
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable throwable) {}
            try {
                is.close();
            }
            catch (Throwable throwable) {}
            try {
                out.close();
            }
            catch (Throwable throwable) {}
            try {
                conn.disconnect();
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    private void bypassSSLSecurityCheck(HttpsURLConnection conn) {
        SSLSocketFactory sslsf = this.getSSLSocketFactory();
        if (sslsf == null) {
            return;
        }
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        conn.setSSLSocketFactory(sslsf);
        conn.setHostnameVerifier(hv);
    }

    private SSLSocketFactory getSSLSocketFactory() {
        if (this.sslSocketFactory == null) {
            this.sslSocketFactory = this.createSSLSocketFactory();
        }
        return this.sslSocketFactory;
    }

    private SSLSocketFactory createSSLSocketFactory() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getErrorMessage(InputStream inp) throws Exception {
        if (inp == null) {
            return null;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(inp, "utf-8"));
            String responseLine = null;
            StringBuilder buff = new StringBuilder();
            while ((responseLine = br.readLine()) != null) {
                buff.append(responseLine.trim());
            }
            String string = buff.toString();
            return string;
        }
        finally {
            try {
                inp.close();
            }
            catch (Throwable throwable) {}
            try {
                br.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void addRequestProperties(HttpURLConnection conn, Map props) {
        if (props == null) {
            return;
        }
        for (Object key : props.keySet()) {
            Object val = props.get(key);
            conn.setRequestProperty(key.toString(), val.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postString(HttpURLConnection conn, String body) throws Exception {
        OutputStream os = null;
        try {
            os = conn.getOutputStream();
            byte[] bytes = body == null ? "".getBytes("UTF-8") : body.getBytes("UTF-8");
            os.write(bytes, 0, bytes.length);
        }
        finally {
            try {
                os.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

