/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.http;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class BasicHttpClient {
    private int readTimeout;
    private int connectTimeout;
    private String contentType;
    private final Map res_header_map = new HashMap();
    private SSLSocketFactory sslSocketFactory;

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    private String encodeValue(String value) {
        try {
            if (value == null) {
                return "";
            }
            if (value.length() == 0) {
                return value;
            }
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Object get(String urlPath, Object data) {
        return this.get(urlPath, data, null);
    }

    public Object get(String urlPath, Object data, Map headers) {
        StringBuilder sb = new StringBuilder();
        if (data instanceof Map) {
            for (Map.Entry me : ((Map)data).entrySet()) {
                String name = this.encodeValue(me.getKey().toString());
                String value = this.encodeValue(me.getValue() == null ? null : me.getValue().toString());
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(name).append("=").append(value);
            }
        } else {
            sb.append(data == null ? "" : data.toString());
        }
        boolean isJson = this.getContentType().toString().endsWith("json");
        StringBuilder pathbuff = new StringBuilder(urlPath);
        if (sb.length() > 0 && !isJson) {
            if (urlPath.indexOf(63) < 0) {
                pathbuff.append("?");
            }
            pathbuff.append(sb.toString());
        }
        if (isJson) {
            return this.invoke("GET", pathbuff.toString(), sb.toString(), headers);
        }
        return this.invoke("GET", pathbuff.toString(), null, headers);
    }

    public final Map getResponseHeaders() {
        return this.res_header_map;
    }

    public final String getResponseHeader(String name) {
        Object value = this.res_header_map.get(name);
        return value == null ? null : value.toString();
    }

    public Object post(String urlPath, Object data) {
        return this.post(urlPath, data, null);
    }

    public Object post(String urlPath, Object data, Map headers) {
        return this.invoke("POST", urlPath, data, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke(String reqMethod, String urlPath, Object data, Map headers) {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlPath);
            conn = (HttpURLConnection)url.openConnection();
            if (conn instanceof HttpsURLConnection) {
                HttpsURLConnection httpsc = (HttpsURLConnection)conn;
                this.bypassSSLSecurityCheck(httpsc);
            }
            if (this.readTimeout > 0) {
                conn.setReadTimeout(this.readTimeout);
            }
            if (this.connectTimeout > 0) {
                conn.setConnectTimeout(this.connectTimeout);
            }
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod(reqMethod);
            String conntype = this.getContentType();
            if (conntype != null && conntype.length() > 0) {
                conn.setRequestProperty("Content-Type", conntype);
            }
            if (headers != null) {
                for (Map.Entry me : headers.entrySet()) {
                    String name = me.getKey() == null ? null : me.getKey().toString();
                    if (name == null || name.length() <= 0) continue;
                    String value = me.getValue() == null ? "" : me.getValue().toString();
                    conn.setRequestProperty(name, value);
                }
            }
            OutputStream out = null;
            try {
                byte[] bytes = null;
                if (data instanceof byte[]) {
                    bytes = (byte[])data;
                    conn.setRequestProperty("Content-Length", "" + bytes.length);
                } else {
                    bytes = (data == null ? "" : data.toString()).getBytes("utf-8");
                    conn.setRequestProperty("Content-Length", "" + bytes.length);
                }
                out = conn.getOutputStream();
                out.write(bytes, 0, bytes.length);
            }
            finally {
                try {
                    out.close();
                }
                catch (Throwable bytes) {}
            }
            this.res_header_map.clear();
            for (String skey : conn.getHeaderFields().keySet()) {
                if (skey == null) continue;
                this.res_header_map.put(skey, conn.getHeaderField(skey));
            }
            Object retVal = null;
            try {
                retVal = this.readData(conn);
            }
            catch (Exception e) {
                retVal = this.readError(conn);
            }
            return retVal;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private Object readData(HttpURLConnection conn) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("responsecode", conn.getResponseCode());
        data.put("response", "OK");
        data.put("data", this.readInputImpl(conn.getInputStream()));
        return data;
    }

    private Object readError(HttpURLConnection conn) throws Exception {
        HashMap<String, Object> err = new HashMap<String, Object>();
        err.put("responsecode", conn.getResponseCode());
        err.put("response", conn.getResponseMessage());
        Object o = this.readInputImpl(conn.getErrorStream());
        if (o == null) {
            o = conn.getHeaderField("x-basic-auth-error");
        }
        if (o == null) {
            StringBuilder sb = new StringBuilder();
            o = conn.getHeaderField("x-client-error");
            if (o != null) {
                sb.append(o);
            }
            if ((o = conn.getHeaderField("x-client-error-detail")) != null) {
                if (sb.length() > 0) {
                    sb.append(": ");
                }
                sb.append(o);
            }
            o = sb.length() > 0 ? sb.toString() : null;
        }
        err.put("error", o == null ? conn.getResponseMessage() : o);
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readInputImpl(InputStream inputs) throws Exception {
        if (inputs == null) {
            return null;
        }
        BufferedReader reader = null;
        InputStreamReader inp = null;
        StringBuilder buff = new StringBuilder();
        String readLine = null;
        try {
            inp = new InputStreamReader(inputs, "utf-8");
            reader = new BufferedReader(inp);
            while ((readLine = reader.readLine()) != null) {
                buff.append(readLine).append("\n");
            }
            String string = buff.toString();
            return string;
        }
        finally {
            try {
                inp.close();
            }
            catch (Throwable throwable) {}
            try {
                reader.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void bypassSSLSecurityCheck(HttpsURLConnection conn) {
        SSLSocketFactory sslsf = this.getSSLSocketFactory();
        if (sslsf == null) {
            return;
        }
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        conn.setSSLSocketFactory(sslsf);
        conn.setHostnameVerifier(hv);
    }

    private SSLSocketFactory getSSLSocketFactory() {
        if (this.sslSocketFactory == null) {
            this.sslSocketFactory = this.createSSLSocketFactory();
        }
        return this.sslSocketFactory;
    }

    private SSLSocketFactory createSSLSocketFactory() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(new KeyManager[0], trustAllCerts, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Throwable t) {
            return null;
        }
    }
}

