/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.functions;

import com.rameses.util.DateUtil;
import com.rameses.util.HolidayProvider;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class DateFunc {
    public static long monthsDiff(Date startMonth, Date endMonth) {
        int m1 = startMonth.getYear() * 12 + startMonth.getMonth();
        int m2 = endMonth.getYear() * 12 + endMonth.getMonth();
        return m2 - m1;
    }

    public static long monthsDiff(Date startMonth, Date endMonth, int baseLine) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(startMonth);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(endMonth);
        int m1 = cal1.get(1) * 12 + cal1.get(2);
        int m2 = cal2.get(1) * 12 + cal2.get(2);
        long diff = m2 - m1;
        if (diff <= 0L) {
            return 0L;
        }
        int d1 = cal1.get(5);
        int d2 = cal2.get(5);
        if (baseLine == 0) {
            int daysInMonth2 = cal2.getActualMaximum(5);
            if (d2 < daysInMonth2) {
                --diff;
            }
        } else if (baseLine == 1) {
            if (d1 > 1) {
                --diff;
            }
        } else if (d1 > baseLine) {
            --diff;
        } else if (d2 < baseLine) {
            --diff;
        }
        if (diff < 0L) {
            diff = 0L;
        }
        return diff;
    }

    public static long yearsDiff(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return 0L;
        }
        long m = DateFunc.monthsDiff(startDate, endDate);
        if (m <= 0L) {
            return 0L;
        }
        return m % 12L;
    }

    public static long daysDiff(Date startDate, Date endDate) {
        return DateUtil.diff(startDate, endDate, 5);
    }

    public static Date startQtrDate(int year, int qtr) {
        Calendar cal = Calendar.getInstance();
        int month = 0;
        switch (qtr) {
            case 1: {
                month = 0;
                break;
            }
            case 2: {
                month = 3;
                break;
            }
            case 3: {
                month = 6;
                break;
            }
            default: {
                month = 9;
            }
        }
        cal.set(year, month, 1, 0, 0);
        return cal.getTime();
    }

    public static int getQtrMonth(int qtr) {
        switch (qtr) {
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 6;
            }
        }
        return 9;
    }

    public static Date endQtrDate(int year, int qtr) {
        Calendar cal = Calendar.getInstance();
        int month = 0;
        switch (qtr) {
            case 1: {
                month = 2;
                break;
            }
            case 2: {
                month = 5;
                break;
            }
            case 3: {
                month = 8;
                break;
            }
            default: {
                month = 11;
            }
        }
        cal.set(year, month, 1, 0, 0);
        return DateFunc.monthEnd(cal.getTime());
    }

    public static Date monthEnd(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int d = cal.getActualMaximum(5);
        cal.set(5, d);
        return cal.getTime();
    }

    public static int getMonth(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        return cal.get(2) + 1;
    }

    public static int getYear(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        return cal.get(1);
    }

    public static int getDay(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        return cal.get(5);
    }

    public static Date getDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getDayAdd(Date dt, int days) {
        return DateUtil.add(dt, days + "d");
    }

    public static Date getMonthAdd(Date dt, int months) {
        return DateUtil.add(dt, months + "M");
    }

    public static int getDayOfWeek(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        return cal.get(7);
    }

    public static Date getFindNextDayOfWeek(Date dt, String dow) {
        return DateFunc.getFindNextDayOfWeek(dt, dow, 1);
    }

    public static Date getFindNextDayOfWeek(Date dt, String dow, int direction) {
        int _dow = 0;
        if (dow.equalsIgnoreCase("SUNDAY")) {
            _dow = 1;
        } else if (dow.equalsIgnoreCase("MONDAY")) {
            _dow = 2;
        } else if (dow.equalsIgnoreCase("TUESDAY")) {
            _dow = 3;
        } else if (dow.equalsIgnoreCase("WEDNESDAY")) {
            _dow = 4;
        } else if (dow.equalsIgnoreCase("THURSDAY")) {
            _dow = 5;
        } else if (dow.equalsIgnoreCase("FRIDAY")) {
            _dow = 6;
        } else if (dow.equalsIgnoreCase("SATURDAY")) {
            _dow = 7;
        }
        int _thisDow = DateFunc.getDayOfWeek(dt);
        if (_thisDow == _dow) {
            return dt;
        }
        int dir = direction > 0 ? 1 : -1;
        Date nd = DateFunc.getDayAdd(dt, dir);
        return DateFunc.getFindNextDayOfWeek(nd, dow, direction);
    }

    public static Date getFindNextWorkDay(Date dt) {
        return DateFunc.getFindNextWorkDay(dt, null, 1);
    }

    public static Date getFindNextWorkDay(Date dt, HolidayProvider holidayProvider) {
        return DateFunc.getFindNextWorkDay(dt, holidayProvider, 1);
    }

    public static Date getFindNextWorkDay(Date dt, HolidayProvider holidayProvider, int option) {
        try {
            int soption = option;
            if (soption == 0) {
                dt = DateFunc.getDayAdd(dt, 1);
                soption = 1;
            }
            int dir = soption < 0 ? -1 : 1;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            int dow = DateFunc.getDayOfWeek(dt);
            int add_days = 0;
            if (dir == 1) {
                if (dow == 1) {
                    add_days = 1;
                } else if (dow == 7) {
                    add_days = 2;
                }
            } else if (dow == 1) {
                add_days = -2;
            } else if (dow == 7) {
                add_days = -1;
            }
            Date d = DateFunc.getDayAdd(dt, add_days);
            if (holidayProvider != null && holidayProvider.exists(d)) {
                Date hd = DateFunc.getDayAdd(d, 1 * dir);
                d = DateFunc.getFindNextWorkDay(hd, holidayProvider, soption);
            }
            return d;
        }
        catch (Exception e) {
            throw new RuntimeException("Error in getFindNextWorkday function " + e.getMessage());
        }
    }

    public static Date formatDate(Object dt, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        String sdt = null;
        sdt = dt instanceof Date ? df.format((Date)dt) : dt.toString();
        try {
            return df.parse(sdt);
        }
        catch (Exception e) {
            System.out.println("error  " + e.getMessage());
            return null;
        }
    }

    public static String dateStringFormat(Date dt, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.format(dt);
        }
        catch (Exception e) {
            System.out.println("error  " + e.getMessage());
            return null;
        }
    }

    public static Date dayOfMonth(int ord, int dow, int month, int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(2, month - 1);
        cal.set(1, year);
        cal.set(7, dow);
        cal.set(8, ord);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }
}

