/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.ftp;

import java.util.HashMap;
import java.util.Map;

public final class FtpLocationConf {
    private static final Config config = new Config();
    private String name;
    private String host;
    private String username;
    private String userpwd;
    private String rootdir;
    private int port;

    public static synchronized FtpLocationConf add(String name) {
        FtpLocationConf conf = FtpLocationConf.config.confs.get(name);
        if (conf == null) {
            conf = new FtpLocationConf(name);
            FtpLocationConf.config.confs.put(name, conf);
        }
        return conf;
    }

    public static synchronized void add(String name, String host, String user, String pwd) {
        FtpLocationConf conf = FtpLocationConf.config.confs.get(name);
        if (conf == null) {
            conf = new FtpLocationConf(name);
            FtpLocationConf.config.confs.put(name, conf);
        }
        conf.setHost(host);
        conf.setUser(user);
        conf.setPassword(pwd);
    }

    public static synchronized FtpLocationConf get(String name) {
        return FtpLocationConf.config.confs.get(name);
    }

    public static synchronized void remove(String name) {
        FtpLocationConf.config.confs.remove(name);
    }

    public static synchronized void clear() {
        FtpLocationConf.config.confs.clear();
    }

    public FtpLocationConf(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        String[] arr = (host == null ? "" : host).split(":");
        this.host = arr[0];
        try {
            this.port = new Integer(arr[1]);
        }
        catch (Throwable t) {
            this.port = 21;
        }
    }

    public String getUser() {
        return this.username;
    }

    public void setUser(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.userpwd;
    }

    public void setPassword(String userpwd) {
        this.userpwd = userpwd;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getRootDir() {
        return this.rootdir;
    }

    public void setRootDir(String rootdir) {
        this.rootdir = rootdir;
    }

    private static class Config {
        Map<String, FtpLocationConf> confs = new HashMap<String, FtpLocationConf>();
        String defaultConfName;

        private Config() {
        }
    }
}

