/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.ftp;

import com.rameses.ftp.FtpClient;
import com.rameses.ftp.FtpException;
import com.rameses.ftp.FtpStreamHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class FtpDownload {
    private final Object HANDLER_LOCK = new Object();
    private FtpClient client;
    private ArrayList<FtpStreamHandler> handlers = new ArrayList();

    private FtpClient getClient() {
        if (this.client == null) {
            this.client = new FtpClient();
        }
        return this.client;
    }

    public void setHost(String host) {
        this.getClient().setHost(host);
    }

    public void setUser(String user) {
        this.getClient().setUser(user);
    }

    public void setPassword(String password) {
        this.getClient().setPassword(password);
    }

    public void setBufferSize(int bufferSize) {
        this.getClient().setBufferSize(bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(FtpStreamHandler handler) {
        Object object = this.HANDLER_LOCK;
        synchronized (object) {
            if (handler != null && !this.handlers.contains(handler)) {
                this.handlers.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(FtpStreamHandler handler) {
        Object object = this.HANDLER_LOCK;
        synchronized (object) {
            if (handler != null) {
                this.handlers.remove(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandlers() {
        Object object = this.HANDLER_LOCK;
        synchronized (object) {
            this.handlers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] download(String filePath) {
        int bufferSize = this.getClient().getBufferSize();
        if (bufferSize <= 0) {
            bufferSize = 65536;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bufferSize);
        try {
            this.download(filePath, baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            try {
                baos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void download(String filePath, OutputStream out) {
        int bufferSize = this.getClient().getBufferSize();
        if (bufferSize <= 0) {
            bufferSize = 65536;
        }
        FtpClient c = this.getClient();
        RelayOutputStream ros = new RelayOutputStream(bufferSize, out);
        try {
            c.connect();
            c.login();
            c.applySettings();
            ros.fileSize = c.getFileSize(filePath);
            FTPClient ftp = c.getFTP();
            ftp.setBufferSize(bufferSize);
            ftp.setRestartOffset(0L);
            ftp.retrieveFile(filePath, (OutputStream)ros);
            int respcode = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)respcode)) {
                throw new FtpException(ftp.getReplyString(), respcode);
            }
            ros.notifyOnComplete();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                c.disconnect();
            }
            catch (Throwable throwable) {}
            try {
                ros.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private class RelayOutputStream
    extends ByteArrayOutputStream {
        long fileSize;
        long processed_count;
        OutputStream transfer;

        RelayOutputStream(int bufferSize, OutputStream transfer) {
            super(bufferSize);
            this.transfer = transfer;
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
            try {
                if (this.transfer != null) {
                    this.transfer.write(b, off, len);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            this.processed_count += (long)len;
            this.notifyOnTransfer(this.processed_count, this.fileSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifyOnTransfer(long processed_count, long file_size) {
            Object object = FtpDownload.this.HANDLER_LOCK;
            synchronized (object) {
                for (FtpStreamHandler h : FtpDownload.this.handlers) {
                    try {
                        h.onTransfer(processed_count, file_size);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifyOnComplete() {
            Object object = FtpDownload.this.HANDLER_LOCK;
            synchronized (object) {
                for (FtpStreamHandler h : FtpDownload.this.handlers) {
                    try {
                        h.onComplete();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }
}

