/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.ftp;

import com.rameses.ftp.FtpException;
import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpClient {
    static final int DEFAULT_BUFFER_SIZE = 65536;
    private String host;
    private String user;
    private String password;
    private int bufferSize;
    private FTPClient ftp;

    final FTPClient getFTP() {
        return this.ftp;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isInited() {
        return this.ftp != null;
    }

    public void connect() {
        if (this.ftp != null) {
            this.disconnect();
        }
        if (this.host == null || this.host.length() == 0) {
            throw new RuntimeException("host is required in FtpClient");
        }
        try {
            String[] arr = this.host.split(":");
            String ipaddr = arr[0];
            int port = 21;
            try {
                port = new Integer(arr[1]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.ftp = new FTPClient();
            this.ftp.connect(ipaddr, port);
            int respcode = this.ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)respcode)) {
                throw new FtpException(this.ftp.getReplyString(), respcode);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void login() {
        if (this.user == null || this.user.length() == 0) {
            throw new RuntimeException("user is required in FtpClient");
        }
        if (this.password == null) {
            throw new RuntimeException("password is required in FtpClient");
        }
        try {
            this.ftp.login(this.user, this.password);
            if (!FTPReply.isPositiveCompletion((int)this.ftp.getReplyCode())) {
                throw new FtpException(this.ftp.getReplyString(), this.ftp.getReplyCode());
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void applySettings() {
        this.ftp.enterLocalPassiveMode();
        this.ftp.setControlKeepAliveTimeout(300L);
        this.ftp.setBufferSize(this.bufferSize > 0 ? this.bufferSize : 65536);
        try {
            this.ftp.setFileType(2);
        }
        catch (IOException e) {
            throw new FtpException(e.getMessage(), e);
        }
    }

    public void logout() {
        try {
            this.ftp.logout();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void disconnect() {
        try {
            this.ftp.disconnect();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.ftp = null;
        }
    }

    public void close() {
        try {
            this.logout();
        }
        finally {
            this.disconnect();
        }
    }

    public FTPFile getFile(String filePath) {
        try {
            return this.ftp.mlistFile(filePath);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public long getFileSize(String filePath) {
        try {
            FTPFile file = this.ftp.mlistFile(filePath);
            if (file == null) {
                throw new IOException("'" + filePath + "' FTP file not found");
            }
            return file.getSize();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

