/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.common;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class MediaFile {
    private String contentType;
    private long lastModified;
    private long contentLength;
    private byte[] content;
    private StreamHandler handler;

    public void setFile(File f) {
        this.handler = f != null ? new FileStreamHandler(f) : null;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public InputStream getInputStream() {
        if (this.handler != null) {
            return this.handler.getInputStream();
        }
        return new ByteArrayInputStream(this.content);
    }

    public StreamHandler getHandler() {
        return this.handler;
    }

    public void setHandler(StreamHandler handler) {
        this.handler = handler;
    }

    public static class FileStreamHandler
    implements StreamHandler {
        private File file;

        public FileStreamHandler(File f) {
            this.file = f;
        }

        @Override
        public InputStream getInputStream() {
            try {
                return new FileInputStream(this.file);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public static interface StreamHandler {
        public InputStream getInputStream();
    }
}

