/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.common;

import com.rameses.common.FunctionResolver;
import com.rameses.util.Service;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ExpressionResolver {
    private Pattern pattern = Pattern.compile("@.*?\\(");
    private Map<String, String> functions;
    private static ExpressionResolver instance;

    private String findFunction(String key) {
        return FunctionResolver.getInstance().findStringFunction(key);
    }

    protected String replaceFunctions(String text) {
        text = text.replaceAll("#\\{", "\\$\\{");
        Matcher m = this.pattern.matcher(text);
        StringBuilder sb = new StringBuilder();
        int start = 0;
        while (m.find()) {
            sb.append(text.substring(start, m.start()));
            String stext = text.substring(m.start(), m.end()).trim();
            String _pre = stext.substring(1, stext.indexOf("("));
            sb.append(this.findFunction(_pre) + "(");
            start = m.end();
        }
        if (start < text.length()) {
            sb.append(text.substring(start));
        }
        return sb.toString();
    }

    public abstract Object eval(String var1, Object var2);

    public abstract String evalString(String var1, Object var2);

    public abstract boolean evalBoolean(String var1, Object var2);

    public abstract double evalDouble(String var1, Object var2);

    public abstract int evalInt(String var1, Object var2);

    public abstract BigDecimal evalDecimal(String var1, Object var2);

    public static ExpressionResolver getInstance() {
        Iterator e;
        if (instance == null && (e = Service.providers(ExpressionResolver.class, ExpressionResolver.class.getClassLoader())).hasNext()) {
            instance = (ExpressionResolver)e.next();
        }
        if (instance == null) {
            throw new RuntimeException("There is no expression resolver specified");
        }
        return instance;
    }
}

