/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.utils;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class Geom {
    private Geom() {
    }

    public static boolean pointInLine(int x1, int y1, int x2, int y2, int px, int py) {
        return Geom.pointInLine(x1, y1, x2, y2, px, py, 3.0);
    }

    public static boolean pointInLine(int x1, int y1, int x2, int y2, int px, int py, double tolerance) {
        Rectangle r = new Rectangle(new Point(x1, y1));
        r.add(x2, y2);
        r.grow(Math.max(2, (int)Math.ceil(tolerance)), Math.max(2, (int)Math.ceil(tolerance)));
        if (!r.contains(px, py)) {
            return false;
        }
        if (x1 == x2) {
            return (double)Math.abs(px - x1) <= tolerance;
        }
        if (y1 == y2) {
            return (double)Math.abs(py - y1) <= tolerance;
        }
        double a = (double)(y1 - y2) / (double)(x1 - x2);
        double b = (double)y1 - a * (double)x1;
        double x = ((double)py - b) / a;
        double y = a * (double)px + b;
        return Math.min(Math.abs(x - (double)px), Math.abs(y - (double)py)) <= tolerance;
    }

    public static long length2(int x1, int y1, int x2, int y2) {
        return (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
    }

    public static long length(int x1, int y1, int x2, int y2) {
        return (long)Math.sqrt(Geom.length2(x1, y1, x2, y2));
    }

    public static double length2(double x1, double y1, double x2, double y2) {
        return (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
    }

    public static double length(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Geom.length2(x1, y1, x2, y2));
    }

    public static double length(Point2D.Double p1, Point2D.Double p2) {
        return Math.sqrt(Geom.length2(p1.x, p1.y, p2.x, p2.y));
    }

    public static Point intersect(int xa, int ya, int xb, int yb, int xc, int yc, int xd, int yd) {
        double denom = (xb - xa) * (yd - yc) - (yb - ya) * (xd - xc);
        double rnum = (ya - yc) * (xd - xc) - (xa - xc) * (yd - yc);
        if (denom == 0.0) {
            if (rnum == 0.0) {
                if (xa < xb && (xb < xc || xb < xd) || xa > xb && (xb > xc || xb > xd)) {
                    return new Point(xb, yb);
                }
                return new Point(xa, ya);
            }
            return null;
        }
        double r = rnum / denom;
        double snum = (ya - yc) * (xb - xa) - (xa - xc) * (yb - ya);
        double s = snum / denom;
        if (0.0 <= r && r <= 1.0 && 0.0 <= s && s <= 1.0) {
            int px = (int)((double)xa + (double)(xb - xa) * r);
            int py = (int)((double)ya + (double)(yb - ya) * r);
            return new Point(px, py);
        }
        return null;
    }

    public static Point northWest(Rectangle r) {
        int x = r.x;
        int y = r.y;
        return new Point(x, y);
    }

    public static Point northEast(Rectangle r) {
        int x = r.x + r.width;
        int y = r.y;
        return new Point(x, y);
    }

    public static Point southEast(Rectangle r) {
        int x = r.x + r.width;
        int y = r.y + r.height;
        return new Point(x, y);
    }

    public static Point southWest(Rectangle r) {
        int x = r.x;
        int y = r.y + r.height;
        return new Point(x, y);
    }
}

