/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.tools;

import com.rameses.osiris2.Invoker;
import com.rameses.rcp.draw.interfaces.Editor;
import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.interfaces.Handle;
import com.rameses.rcp.draw.interfaces.Tool;
import com.rameses.rcp.draw.tools.AbstractTool;
import com.rameses.rcp.draw.tools.HandleTool;
import com.rameses.rcp.draw.tools.MultiSelectTool;
import com.rameses.rcp.draw.tools.SelectAreaTool;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.SwingUtilities;

public class SelectionTool
extends AbstractTool {
    private Tool toolDelegate;
    private boolean hasDragged = false;

    public SelectionTool() {
    }

    public SelectionTool(Editor editor) {
        super(editor);
    }

    @Override
    public void mousePressed(int x, int y, MouseEvent e) {
        super.mousePressed(x, y, e);
        if (this.toolDelegate != null) {
            return;
        }
        this.hasDragged = false;
        Handle handle = this.getDrawing().handleAt(x, y);
        if (handle != null) {
            handle.setEditor(this.getEditor());
            this.toolDelegate = new HandleTool(this.getEditor(), handle);
        } else {
            Figure figure = null;
            figure = e.isControlDown() ? this.getDrawing().innerFigureAt(x, y) : this.getDrawing().figureAt(x, y);
            if (figure != null) {
                this.toolDelegate = new MultiSelectTool(this.getEditor(), figure);
            } else {
                if (!e.isShiftDown()) {
                    this.getEditor().getDrawing().clearSelections();
                }
                this.toolDelegate = new SelectAreaTool(this.getEditor());
            }
        }
        this.toolDelegate.mousePressed(x, y, e);
    }

    @Override
    public void mouseClicked(int x, int y, MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
            this.openFigure(x, y, e);
        }
    }

    @Override
    public void mouseMoved(int x, int y, MouseEvent e) {
        Handle h = this.getDrawing().handleAt(x, y);
        if (h != null && h.getOwner().isAllowResize()) {
            this.getCanvas().setCursor(h.getCursor());
        } else {
            this.getCanvas().setCursor(new Cursor(0));
        }
    }

    @Override
    public void mouseDrag(int x, int y, MouseEvent e) {
        if (this.toolDelegate != null) {
            this.toolDelegate.mouseDrag(x, y, e);
            this.hasDragged = true;
        }
    }

    @Override
    public void mouseReleased(int x, int y, MouseEvent e) {
        if (this.toolDelegate != null) {
            this.toolDelegate.mouseReleased(x, y, e);
            this.toolDelegate = null;
        }
    }

    @Override
    public void openFigure(int x, int y, MouseEvent e) {
        Figure figure = this.getDrawing().figureAt(x, y);
        if (figure != null) {
            this.getEditor().openFigure(figure);
        }
    }

    @Override
    public void showMenu(int x, int y, int sx, int sy, MouseEvent e) {
        List<Invoker> menus;
        Figure figure = this.getDrawing().figureAt(x, y);
        if (figure != null && !(menus = this.getEditor().showMenu(figure)).isEmpty()) {
            this.getEditor().getCanvas().showMenu(sx, sy, menus);
        }
    }

    @Override
    public Cursor getToolCursor() {
        return new Cursor(0);
    }
}

