/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.tools;

import com.rameses.rcp.draw.figures.PolyLineFigure;
import com.rameses.rcp.draw.interfaces.Editor;
import com.rameses.rcp.draw.tools.AbstractTool;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class PolyLineTool
extends AbstractTool {
    private PolyLineFigure createdFigure;
    private boolean processing;

    public PolyLineTool() {
        this.processing = false;
    }

    public PolyLineTool(Editor editor) {
        this(editor, null);
    }

    public PolyLineTool(Editor editor, Class<PolyLineFigure> prototype) {
        super(editor);
        this.setPrototype(prototype);
        this.processing = false;
    }

    @Override
    public void mousePressed(int x, int y, MouseEvent e) {
        if (!this.processing) {
            super.mousePressed(x, y, e);
            this.createdFigure = this.createFigure();
            this.createdFigure.addPoint(x, y);
            this.createdFigure.addPoint(x, y);
            this.getEditor().addToDrawing(this.createdFigure);
            this.processing = true;
        }
    }

    @Override
    public void mouseMoved(int x, int y, MouseEvent e) {
        if (this.processing) {
            this.createdFigure.updateEndPoint(x, y);
        }
    }

    @Override
    public void mouseClicked(int x, int y, MouseEvent e) {
        this.createdFigure.addPoint(x, y);
        this.createdFigure.updateEndPoint(x, y);
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
            if (this.createdFigure.isEmpty()) {
                this.getDrawing().removeFigure(this.createdFigure);
            } else {
                this.createdFigure.smoothenPoints();
                this.getEditor().figureAdded(this.createdFigure);
                this.getCanvas().revalidateRect(this.createdFigure.getDisplayBox());
            }
            this.processing = false;
        }
    }

    @Override
    public void cancel() {
        this.getDrawing().removeFigure(this.createdFigure);
        this.createdFigure = null;
        this.getEditor().setCurrentTool(this.getEditor().getDefaultTool());
        this.getCanvas().refresh();
    }

    private PolyLineFigure createFigure() {
        try {
            return (PolyLineFigure)this.getPrototype().newInstance();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

