/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.tools;

import com.rameses.rcp.draw.figures.ImageFigure;
import com.rameses.rcp.draw.interfaces.Editor;
import com.rameses.rcp.draw.tools.AbstractTool;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class ImageTool
extends AbstractTool {
    public ImageTool() {
    }

    public ImageTool(Editor editor) {
        this(editor, null);
    }

    public ImageTool(Editor editor, Class prototype) {
        super(editor);
        this.setPrototype(prototype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(int x, int y, MouseEvent e) {
        JFileChooser jfc = new JFileChooser();
        int retval = jfc.showOpenDialog(null);
        if (retval == 1) {
            this.resetTool();
            return;
        }
        try {
            File file = jfc.getSelectedFile();
            BufferedImage img = ImageIO.read(file);
            ImageFigure figure = new ImageFigure();
            figure.setImage(img);
            figure.setDisplayBox(x, y, x + img.getWidth(), y + img.getHeight());
            this.getEditor().addToDrawing(figure);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error loading image file.");
        }
        finally {
            this.resetTool();
        }
    }

    private void resetTool() {
        this.getEditor().setCurrentTool(this.getEditor().getDefaultTool());
    }
}

