/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.tools;

import com.rameses.rcp.draw.interfaces.Editor;
import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.interfaces.Handle;
import com.rameses.rcp.draw.tools.AbstractTool;
import java.awt.Cursor;
import java.awt.event.MouseEvent;

public class HandleTool
extends AbstractTool {
    private Handle handle;

    public HandleTool(Editor editor, Handle handle) {
        super(editor);
        this.handle = handle;
    }

    @Override
    public void mousePressed(int x, int y, MouseEvent e) {
        super.mousePressed(x, y, e);
        this.handle.doStart(x, y, e);
    }

    @Override
    public void mouseDrag(int x, int y, MouseEvent e) {
        super.mouseDrag(x, y, e);
        if (this.handle.getOwner().isAllowResize()) {
            this.handle.doStep(x, y, e);
        }
    }

    @Override
    public void mouseMoved(int x, int y, MouseEvent e) {
        if (this.handle.getOwner().isAllowResize()) {
            this.getCanvas().setCursor(this.handle.getCursor());
        } else {
            this.getCanvas().setCursor(new Cursor(0));
        }
    }

    @Override
    public void mouseReleased(int x, int y, MouseEvent e) {
        super.mouseReleased(x, y, e);
        this.handle.doEnd(x, y, e);
    }

    protected Handle getHandle() {
        return this.handle;
    }

    protected Figure getOwner() {
        return this.handle.getOwner();
    }
}

