/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.tools;

import com.rameses.rcp.draw.figures.LineConnector;
import com.rameses.rcp.draw.interfaces.Connector;
import com.rameses.rcp.draw.interfaces.Editor;
import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.interfaces.Handle;
import com.rameses.rcp.draw.interfaces.Tool;
import com.rameses.rcp.draw.tools.AbstractTool;
import com.rameses.rcp.draw.tools.ConnectorHandleTool;
import com.rameses.rcp.draw.utils.DrawUtil;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class ConnectorTool
extends AbstractTool {
    private Figure selectedFigure;
    private LineConnector connector;
    private LineConnector selectedConnector;
    private boolean connecting = false;
    private boolean allowChop = false;
    private boolean dragging = false;
    private Point chopPoint;
    private static Cursor splitCursor;
    private static Cursor combineCursor;
    private Tool toolDelegate;

    public ConnectorTool() {
    }

    public ConnectorTool(Editor editor) {
        super(editor);
    }

    @Override
    public void mousePressed(int x, int y, MouseEvent e) {
        super.mousePressed(x, y, e);
        Handle handle = this.getDrawing().handleAt(x, y);
        if (!this.isCtrlPressed(e) && handle != null) {
            this.toolDelegate = new ConnectorHandleTool(this.getEditor(), handle);
        } else if (!this.connecting) {
            this.selectedFigure = this.getDrawing().figureAt(x, y);
            if (this.selectedFigure != null && this.isConnector(this.selectedFigure)) {
                this.selectedConnector = (LineConnector)this.selectedFigure;
                this.getEditor().addToSelections(this.selectedConnector);
            }
        }
    }

    @Override
    public void mouseMoved(int x, int y, MouseEvent e) {
        if (this.toolDelegate != null) {
            return;
        }
        if (this.connecting) {
            this.handleConnection(x, y, e);
        } else {
            this.selectedConnector = (LineConnector)this.getDrawing().connectorAt(x, y);
            this.handleConnector(x, y, e);
        }
    }

    @Override
    public void mouseDrag(int x, int y, MouseEvent e) {
        if (this.toolDelegate != null) {
            this.toolDelegate.mouseDrag(x, y, e);
        } else if (this.isConnector(this.selectedFigure)) {
            if (!this.dragging) {
                this.selectedConnector = (LineConnector)this.selectedFigure;
                this.getDrawing().addSelection(this.selectedFigure);
                this.chopConnector(x, y, e);
                this.dragging = true;
            } else if (this.chopPoint != null) {
                this.chopPoint.x = x;
                this.chopPoint.y = y;
            }
        }
    }

    @Override
    public void mouseReleased(int x, int y, MouseEvent e) {
        Handle handle;
        if (this.toolDelegate != null) {
            this.toolDelegate.mouseReleased(x, y, e);
            this.toolDelegate = null;
            return;
        }
        if (this.selectedConnector != null && (handle = this.getDrawing().handleAt(x, y)) != null && this.isCtrlPressed(e)) {
            this.selectedConnector.chop(x, y, false);
            this.getCanvas().revalidateRect(this.selectedConnector.getDisplayBox());
        }
        this.selectedFigure = this.getDrawing().figureAt(x, y, this.connector);
        if (this.isConnectionAllowed(this.selectedFigure)) {
            if (!this.connecting) {
                this.connectStartFigure(x, y, e);
            } else {
                this.connectEndFigure(x, y, e);
                if (this.selectedConnector != null) {
                    this.getEditor().figureAdded(this.selectedConnector);
                    this.getCanvas().revalidateRect(this.selectedConnector.getDisplayBox());
                }
            }
        } else if (this.connecting && this.connector != null) {
            this.connector.addPoint(x, y);
        }
        this.dragging = false;
    }

    private void connectStartFigure(int x, int y, MouseEvent e) {
        this.connector = new LineConnector();
        this.connector.setStartFigure(this.selectedFigure);
        this.connector.updateStartPoint(x, y);
        this.connector.updateEndPoint(x, y);
        this.getEditor().addToConnector(this.connector);
        this.selectedFigure = null;
        this.connecting = true;
    }

    private void connectEndFigure(int x, int y, MouseEvent e) {
        this.connector.setEndFigure(this.selectedFigure);
        if (this.checkDuplicateConnector()) {
            this.getEditor().getDrawing().removeConnector(this.connector);
            this.connector = null;
        }
        this.setDefaultCursor();
        this.connecting = false;
        this.selectedFigure = null;
    }

    private boolean isConnectionAllowed(Figure figure) {
        if (figure == null || this.isConnector(figure)) {
            return false;
        }
        if (!figure.isConnectionAllowed()) {
            return false;
        }
        if (!this.connecting && !figure.isStartConnectionAllowed()) {
            return false;
        }
        if (this.connecting && !figure.isEndConnectionAllowed()) {
            return false;
        }
        if (this.connecting && this.connector.getStartFigure() == figure) {
            return false;
        }
        return this.connector == null || this.connector.getEndFigure() == null || this.connector.getEndFigure() != figure;
    }

    private boolean isConnector(Figure figure) {
        if (figure == null) {
            return false;
        }
        return figure instanceof Connector;
    }

    private void handleConnection(int x, int y, MouseEvent e) {
        this.selectedFigure = this.getDrawing().figureAt(x, y);
        if (this.isConnectionAllowed(this.selectedFigure)) {
            this.setTargetCursor();
        } else {
            this.selectedFigure = null;
            this.setDefaultCursor();
        }
        if (this.connecting) {
            this.connector.updateEndPoint(x, y);
        }
    }

    private void handleConnector(int x, int y, MouseEvent e) {
        if (this.selectedConnector != null) {
            Handle handle = this.getDrawing().handleAt(x, y);
            if (this.isCtrlPressed(e) && handle != null) {
                this.getCanvas().setCursor(this.getCombineCusor());
            } else if (this.selectedConnector.allowChop(x, y)) {
                this.getCanvas().setCursor(this.getSplitCusor());
            }
        } else {
            this.setToolCursor();
        }
    }

    private void chopConnector(int x, int y, MouseEvent e) {
        if (!this.isCtrlPressed(e)) {
            this.allowChop = this.selectedConnector.allowChop(x, y);
            if (this.allowChop) {
                this.chopPoint = this.selectedConnector.chop(x, y, true);
                this.getCanvas().refresh();
            }
        }
    }

    @Override
    public Cursor getToolCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    private Cursor getCombineCusor() {
        if (combineCursor == null) {
            combineCursor = DrawUtil.createCustomCursor("delete-cursor16.png");
        }
        return combineCursor;
    }

    private Cursor getSplitCusor() {
        if (splitCursor == null) {
            splitCursor = DrawUtil.createCustomCursor("add-cursor16.png");
        }
        return splitCursor;
    }

    private void setTargetCursor() {
        this.getCanvas().setCursor(Cursor.getPredefinedCursor(1));
    }

    @Override
    public void cancel() {
        if (this.connector.getStartFigure() != null) {
            this.connector.getStartFigure().removeConnector(this.connector);
        }
        if (this.connector.getEndFigure() != null) {
            this.connector.getEndFigure().removeConnector(this.connector);
        }
        this.getDrawing().removeConnector(this.connector);
        this.selectedFigure = null;
        this.selectedConnector = null;
        this.connector = null;
        this.connecting = false;
        this.dragging = false;
        this.getEditor().setCurrentTool(this.getEditor().getDefaultTool());
        this.getCanvas().refresh();
    }

    private boolean checkDuplicateConnector() {
        for (Connector c : this.getDrawing().getConnectors()) {
            if (c.getStartFigure() != this.connector.getStartFigure() || c.getEndFigure() != this.connector.getEndFigure() || c == this.connector) continue;
            return true;
        }
        return false;
    }
}

