/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.tools;

import com.rameses.rcp.draw.figures.WorkflowDecision;
import com.rameses.rcp.draw.figures.WorkflowNode;
import com.rameses.rcp.draw.interfaces.Connector;
import com.rameses.rcp.draw.interfaces.Editor;
import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.interfaces.Handle;
import com.rameses.rcp.draw.tools.HandleTool;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class ConnectorHandleTool
extends HandleTool {
    public ConnectorHandleTool(Editor editor, Handle handle) {
        super(editor, handle);
    }

    @Override
    public void mouseMoved(int x, int y, MouseEvent e) {
        Figure toFigure = this.getDrawing().figureAt(x, y, this.getOwner());
        if (this.isAllowConnect(toFigure, x, y)) {
            this.getCanvas().setCursor(this.getHandle().getCursor());
        } else {
            this.getCanvas().setCursor(new Cursor(0));
        }
    }

    @Override
    public void mouseReleased(int x, int y, MouseEvent e) {
        super.mouseReleased(x, y, e);
        Figure toFigure = this.getDrawing().figureAt(x, y, this.getOwner());
        if (!this.isAllowConnect(toFigure, x, y)) {
            return;
        }
        Connector c = (Connector)((Object)this.getOwner());
        Figure fromFigure = null;
        if (this.isHead(x, y)) {
            fromFigure = c.getEndFigure();
            c.setEndFigure(toFigure);
        } else {
            fromFigure = c.getStartFigure();
            c.setStartFigure(toFigure, true);
            c.setEndFigure(c.getEndFigure());
        }
        fromFigure.removeConnector(c);
        toFigure.addConnector(c);
        this.getEditor().connectionChanged(c, fromFigure, toFigure);
    }

    private boolean isAllowConnect(Figure f, int x, int y) {
        if (f == null) {
            return false;
        }
        if (!(f instanceof WorkflowNode) && !(f instanceof WorkflowDecision)) {
            return false;
        }
        if (!f.isConnectionAllowed()) {
            return false;
        }
        if (this.isHead(x, y) && !f.isEndConnectionAllowed()) {
            return false;
        }
        if (this.isTail(x, y) && !f.isStartConnectionAllowed()) {
            return false;
        }
        return this.isHead(x, y) || this.isTail(x, y);
    }

    private boolean isHead(int x, int y) {
        Connector c = (Connector)((Object)this.getOwner());
        Point p = c.getPoints().get(c.getPoints().size() - 1);
        return this.getHandle().getDisplayBox().contains(p);
    }

    private boolean isTail(int x, int y) {
        Connector c = (Connector)((Object)this.getOwner());
        Point p = c.getPoints().get(0);
        return this.getHandle().getDisplayBox().contains(p);
    }
}

