/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.tools;

import com.rameses.rcp.draw.interfaces.Canvas;
import com.rameses.rcp.draw.interfaces.Drawing;
import com.rameses.rcp.draw.interfaces.Editor;
import com.rameses.rcp.draw.interfaces.Tool;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;

public abstract class AbstractTool
implements Tool {
    private Class prototype;
    private Editor editor;
    private Point startPoint;
    private boolean active = true;

    public AbstractTool() {
    }

    public AbstractTool(Editor editor) {
        this.editor = editor;
        this.setToolCursor();
    }

    @Override
    public Editor getEditor() {
        return this.editor;
    }

    @Override
    public void setEditor(Editor editor) {
        this.editor = editor;
    }

    @Override
    public Drawing getDrawing() {
        return this.getEditor().getDrawing();
    }

    @Override
    public Canvas getCanvas() {
        return this.getEditor().getCanvas();
    }

    @Override
    public Class getPrototype() {
        return this.prototype;
    }

    @Override
    public void setPrototype(Class prototype) {
        this.prototype = prototype;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void mousePressed(int x, int y, MouseEvent e) {
        this.startPoint = new Point(x, y);
    }

    @Override
    public void mouseReleased(int x, int y, MouseEvent e) {
    }

    @Override
    public void mouseClicked(int x, int y, MouseEvent e) {
    }

    @Override
    public void openFigure(int x, int y, MouseEvent e) {
    }

    @Override
    public void showMenu(int x, int y, int sx, int sy, MouseEvent e) {
    }

    @Override
    public void mouseDrag(int x, int y, MouseEvent e) {
    }

    @Override
    public void mouseMoved(int x, int y, MouseEvent e) {
    }

    @Override
    public Point getStartPoint() {
        return this.startPoint;
    }

    @Override
    public void setStartPoint(Point startPoint) {
        this.startPoint = startPoint;
    }

    @Override
    public int getStartX() {
        return this.startPoint.x;
    }

    @Override
    public int getStartY() {
        return this.startPoint.y;
    }

    @Override
    public void setToolCursor() {
        if (this.getCanvas() != null) {
            this.getCanvas().setCursor(this.getToolCursor());
        }
    }

    @Override
    public Cursor getToolCursor() {
        return new Cursor(1);
    }

    protected void setDefaultCursor() {
        if (this.getCanvas() != null) {
            this.getCanvas().setCursor(this.getDefaultCursor());
        }
    }

    protected Cursor getDefaultCursor() {
        return new Cursor(0);
    }

    protected boolean isCtrlPressed(MouseEvent e) {
        return (e.getModifiersEx() & 0x80) != 0;
    }

    protected boolean isShiftPressed(MouseEvent e) {
        return (e.getModifiersEx() & 0x40) != 0;
    }
}

