/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.support;

import com.rameses.rcp.draw.StdDrawing;
import com.rameses.rcp.draw.figures.FigureFactory;
import com.rameses.rcp.draw.figures.LineConnector;
import com.rameses.rcp.draw.interfaces.Drawing;
import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.support.AttributeKey;
import com.rameses.rcp.draw.support.AttributeKeys;
import com.rameses.rcp.draw.support.XmlDataExtractor;
import groovy.util.slurpersupport.NodeChild;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import java.util.Map;

public class DrawingBuilder {
    private Drawing drawing = new StdDrawing();
    private XmlDataExtractor xde;

    public Drawing buildDrawing(File file) {
        return this.buildDrawing(this.loadXml(file));
    }

    public Drawing buildDrawing(String xml) {
        String gpath = "Drawing.Figures.Figure.collect{it}";
        this.xde = new XmlDataExtractor(xml, "Drawing");
        List figures = (List)this.xde.extract(gpath);
        for (NodeChild figureNode : figures) {
            Map prop = figureNode.attributes();
            Figure figure = FigureFactory.createFigure(prop);
            if (figure == null) continue;
            this.processAttributeKeys(figure, figureNode);
            this.processConnector(figure, prop);
            this.drawing.addFigure(figure);
        }
        this.xde = null;
        return this.drawing;
    }

    private void processAttributeKeys(Figure figure, NodeChild figureNode) {
        String gpath = "Drawing.Figures.Figure.find{it.'@id' == " + figure.getId() + "}.attributes.collect{it.attributes()}";
        List attributes = (List)this.xde.extract(gpath);
        for (Map attr : attributes) {
            for (Map.Entry entry : attr.entrySet()) {
                AttributeKey ak = AttributeKeys.findByKey((String)entry.getKey());
                if (ak == null) continue;
                figure.set(ak, ak.decode(entry.getValue(), ak.getAttributeClass()));
            }
        }
    }

    private String loadXml(File file) {
        FileReader reader = null;
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String s;
            reader = new FileReader(file);
            br = new BufferedReader(reader);
            while ((s = br.readLine()) != null) {
                sb.append(s);
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void processConnector(Figure figure, Map prop) {
        if (!(figure instanceof LineConnector)) {
            return;
        }
        LineConnector connector = (LineConnector)figure;
        String startId = prop.get("startFigureId").toString();
        String endId = prop.get("endFigureId").toString();
        connector.setStartFigure(this.drawing.figureById(startId));
        connector.setEndFigure(this.drawing.figureById(endId));
    }
}

