/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.support;

import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.support.AttributeKey;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Stroke;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class AttributeKeys {
    private static final Map<String, AttributeKey> keys = new HashMap<String, AttributeKey>();
    public static final AttributeKey<Dimension> CANVAS_SIZE = new AttributeKey<Dimension>("canvasBackgroundColor", Dimension.class, new Dimension(400, 300));
    public static final AttributeKey<Color> CANVAS_BACKGROUND_COLOR = new AttributeKey<Color>("canvasBackgroundColor", Color.class, Color.WHITE);
    public static final AttributeKey<Integer> FIGURE_MINIMUM_WIDTH = new AttributeKey<Integer>("figureMinimumWidth", Integer.class, 2);
    public static final AttributeKey<Integer> FIGURE_MINIMUM_HEIGHT = new AttributeKey<Integer>("figureMinimumHeight", Integer.class, 2);
    public static final AttributeKey<Color> FILL_COLOR = new AttributeKey<Color>("fillColor", Color.class, Color.WHITE);
    public static final AttributeKey<Color> STROKE_COLOR = new AttributeKey<Color>("strokeColor", Color.class, Color.BLUE);
    public static final AttributeKey<Double> STROKE_WIDTH = new AttributeKey<Double>("strokeWidth", Double.class, 1.0);
    public static final AttributeKey<Double> STROKE_MITER_LIMIT = new AttributeKey<Double>("strokeMiterLimitFactor", Double.class, 3.0);
    public static final AttributeKey<Boolean> IS_STROKE_DASH_FACTOR = new AttributeKey<Boolean>("isStrokeDashFactor", Boolean.class, true);
    public static final AttributeKey<Double> STROKE_DASH_PHASE = new AttributeKey<Double>("strokeDashPhase", Double.class, 0.0);
    public static final AttributeKey<double[]> STROKE_DASHES = new AttributeKey<Object>("strokeDashes", double[].class, null);
    public static final AttributeKey<Integer> STROKE_CAP = new AttributeKey<Integer>("strokeCap", Integer.class, 0);
    public static final AttributeKey<StrokeType> STROKE_TYPE = new AttributeKey<StrokeType>("strokeType", StrokeType.class, StrokeType.BASIC);
    public static final AttributeKey<Boolean> CENTER_TEXT = new AttributeKey<Boolean>("centerText", Boolean.class, new Boolean(true));
    public static final AttributeKey<Color> TEXT_COLOR = new AttributeKey<Color>("textColor", Color.class, Color.BLACK);
    public static final AttributeKey<Color> TEXT_BACKGROUND = new AttributeKey<Color>("textBackground", Color.class, Color.WHITE);
    public static final AttributeKey<Font> FONT_FACE = new AttributeKey<Font>("fontFace", Font.class, new Font("VERDANA", 0, 10));
    public static final AttributeKey<Double> STROKE_INNER_WIDTH_FACTOR = new AttributeKey<Double>("innerStrokeWidthFactor", Double.class, 2.0);
    public static final AttributeKey<Integer> STROKE_JOIN = new AttributeKey<Integer>("strokeJoin", Integer.class, 0);
    public static final AttributeKey<Dimension> WORKFLOW_NODE_DIMENSION = new AttributeKey<Dimension>("workflowNodeDimension", Dimension.class, new Dimension(32, 32));
    public static final AttributeKey<Dimension> WORKFLOW_WAIT_DIMENSION = new AttributeKey<Dimension>("workflowWaitDimension", Dimension.class, new Dimension(32, 32));
    public static final AttributeKey<Double> ROTATION_ANGLE = new AttributeKey<Double>("rotation", Double.class, 0.0);

    public static Stroke getStroke(Figure f) {
        double strokeWidth = f.get(STROKE_WIDTH);
        double miterLimit = f.get(STROKE_MITER_LIMIT);
        double dashFactor = f.get(IS_STROKE_DASH_FACTOR) != false ? strokeWidth : 1.0;
        double dashPhase = f.get(STROKE_DASH_PHASE);
        double[] ddashes = f.get(STROKE_DASHES);
        float[] dashes = null;
        boolean isAllZeroes = true;
        if (ddashes != null) {
            dashes = new float[ddashes.length];
            double dashSize = 0.0;
            for (int i = 0; i < dashes.length; ++i) {
                dashes[i] = Math.max(0.0f, (float)(ddashes[i] * dashFactor));
                dashSize += (double)dashes[i];
                if (!isAllZeroes || dashes[i] == 0.0f) continue;
                isAllZeroes = false;
            }
            if (dashes.length % 2 == 1) {
                dashSize *= 2.0;
            }
            if (dashPhase < 0.0) {
                dashPhase = dashSize + dashPhase % dashSize;
            }
        }
        if (isAllZeroes) {
            dashes = null;
        }
        switch (f.get(STROKE_TYPE)) {
            default: 
        }
        return new BasicStroke((float)strokeWidth, f.get(STROKE_CAP), f.get(STROKE_JOIN), (float)miterLimit, dashes, Math.max(0.0f, (float)(dashPhase * dashFactor)));
    }

    public static AttributeKey findByKey(String key) {
        AttributeKey ak = keys.get(key);
        if (ak == null && (ak = AttributeKeys.getAttributeKey(key)) != null) {
            keys.put(key, ak);
        }
        return ak;
    }

    private static AttributeKey getAttributeKey(String key) {
        for (Field fld : AttributeKeys.class.getFields()) {
            int mod = fld.getModifiers();
            if (!Modifier.isFinal(mod) || !Modifier.isStatic(mod)) continue;
            try {
                AttributeKey ak = (AttributeKey)fld.get(null);
                if (!ak.getKey().equals(key)) continue;
                return ak;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                break;
            }
        }
        return null;
    }

    public static enum StrokeType {
        BASIC;

    }
}

