/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.handles;

import com.rameses.rcp.draw.handles.AbstractHandle;
import com.rameses.rcp.draw.handles.RelativeEastHandle;
import com.rameses.rcp.draw.handles.RelativeNorthEastHandle;
import com.rameses.rcp.draw.handles.RelativeNorthHandle;
import com.rameses.rcp.draw.handles.RelativeNorthWestHandle;
import com.rameses.rcp.draw.handles.RelativeSouthEastHandle;
import com.rameses.rcp.draw.handles.RelativeSouthHandle;
import com.rameses.rcp.draw.handles.RelativeSouthWestHandle;
import com.rameses.rcp.draw.handles.RelativeWestHandle;
import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.interfaces.Handle;
import com.rameses.rcp.draw.undo.UndoableResize;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class RelativeHandle
extends AbstractHandle {
    private Rectangle prevBounds;

    public RelativeHandle(double offsetX, double offsetY) {
        super(offsetX, offsetY);
    }

    public RelativeHandle(Figure owner, double offsetX, double offsetY) {
        super(owner, offsetX, offsetY);
    }

    @Override
    public void doStart(int dx, int dy, MouseEvent e) {
        super.doStart(dx, dy, e);
        this.prevBounds = this.getOwner().getBounds();
    }

    @Override
    public void doStep(int dx, int dy, MouseEvent e) {
    }

    @Override
    public void doEnd(int dx, int dy, MouseEvent e) {
        super.doEnd(dx, dy, e);
        if (this.getEditor() != null) {
            this.logResizeUndoEdit();
        }
    }

    public static Handle north(Figure owner) {
        return new RelativeNorthHandle(owner);
    }

    public static Handle northEast(Figure owner) {
        return new RelativeNorthEastHandle(owner);
    }

    public static Handle east(Figure owner) {
        return new RelativeEastHandle(owner);
    }

    public static Handle southEast(Figure owner) {
        return new RelativeSouthEastHandle(owner);
    }

    public static Handle south(Figure owner) {
        return new RelativeSouthHandle(owner);
    }

    public static Handle southWest(Figure owner) {
        return new RelativeSouthWestHandle(owner);
    }

    public static Handle west(Figure owner) {
        return new RelativeWestHandle(owner);
    }

    public static Handle northWest(Figure owner) {
        return new RelativeNorthWestHandle(owner);
    }

    private void logResizeUndoEdit() {
        UndoableResize edit = new UndoableResize(this.getOwner(), this.prevBounds, this.getOwner().getBounds());
        this.getEditor().getUndoRedoManager().addEdit(edit);
    }
}

