/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.figures;

import com.rameses.rcp.draw.figures.ImageFigure;
import com.rameses.rcp.draw.interfaces.Tool;
import com.rameses.rcp.draw.support.AttributeKeys;
import com.rameses.rcp.draw.tools.WorkflowCreationTool;
import com.rameses.rcp.draw.utils.DrawUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class WorkflowDecision
extends ImageFigure {
    private int nPoints = 4;
    private int[] xPoints = new int[this.nPoints];
    private int[] yPoints = new int[this.nPoints];

    public WorkflowDecision() {
        this.set(AttributeKeys.FILL_COLOR, Color.LIGHT_GRAY);
    }

    @Override
    public String getCategory() {
        return "workflow";
    }

    @Override
    public String getToolCaption() {
        return "Decision";
    }

    @Override
    public String getType() {
        return "decision";
    }

    @Override
    public String getIcon() {
        return "images/draw/workflow-decision16.png";
    }

    @Override
    public Tool getTool() {
        return new WorkflowCreationTool();
    }

    @Override
    protected void drawFigure(Graphics2D g) {
        if (this.getImage() == null) {
            this.drawNodeSymbol(g);
            this.drawCaption(g);
        } else {
            super.drawFigure(g);
        }
    }

    protected void drawNodeSymbol(Graphics2D g) {
        this.buildPolygonPoints();
        g.setStroke(AttributeKeys.getStroke(this));
        g.setColor(this.get(AttributeKeys.FILL_COLOR));
        g.fillPolygon(this.xPoints, this.yPoints, this.nPoints);
        g.setColor(this.get(AttributeKeys.STROKE_COLOR));
        g.drawPolygon(this.xPoints, this.yPoints, this.nPoints);
    }

    @Override
    public boolean isEmpty() {
        Rectangle r = this.getDisplayBox();
        return r.width <= 2 || r.height <= 2;
    }

    @Override
    protected void drawIndex(Graphics2D g) {
        Rectangle r = this.getDisplayBox();
        Dimension ts = DrawUtil.getTextSize(g, this.getIndex() + "");
        int x = r.x + (r.width - ts.width) / 2;
        int y = r.y + r.height + ts.height - 4;
        g.setColor(Color.RED);
        g.drawString(this.getIndex() + "", x, y);
    }

    private void buildPolygonPoints() {
        Rectangle r = this.getDisplayBox();
        this.xPoints[0] = r.x + r.width / 2;
        this.yPoints[0] = r.y;
        this.xPoints[1] = r.x + r.width;
        this.yPoints[1] = r.y + r.height / 2;
        this.xPoints[2] = r.x + r.width / 2;
        this.yPoints[2] = r.y + r.height;
        this.xPoints[3] = r.x;
        this.yPoints[3] = r.y + r.height / 2;
    }
}

