/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.figures;

import com.rameses.rcp.draw.figures.AbstractAttributedFigure;
import com.rameses.rcp.draw.handles.TextHandles;
import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.interfaces.Handle;
import com.rameses.rcp.draw.interfaces.Tool;
import com.rameses.rcp.draw.support.AttributeKey;
import com.rameses.rcp.draw.support.AttributeKeys;
import com.rameses.rcp.draw.support.RotatedRectangle;
import com.rameses.rcp.draw.tools.TextTool;
import com.rameses.rcp.draw.utils.DataUtil;
import com.rameses.rcp.draw.utils.DrawUtil;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;

public class TextFigure
extends AbstractAttributedFigure {
    private String text;
    private BufferedImage rotatedText;
    private RotatedRectangle rotatedRect = new RotatedRectangle();
    private Figure parentFigure;

    public TextFigure() {
    }

    public TextFigure(String text, int x, int y) {
        this(text, x, y, 100, 20);
    }

    public TextFigure(String text, int x, int y, int width, int height) {
        this.setDisplayBox(x, y, x + width, y + height);
        this.setText(text);
    }

    @Override
    public String getToolCaption() {
        return "Text";
    }

    @Override
    public String getType() {
        return "text";
    }

    @Override
    public Tool getTool() {
        return new TextTool();
    }

    @Override
    public String getIcon() {
        return "images/draw/text16.png";
    }

    @Override
    public List<Handle> getHandles() {
        TextHandles.addHandles(this);
        return super.getHandles();
    }

    public Figure getParentFigure() {
        return this.parentFigure;
    }

    public void setParentFigure(Figure parentFigure) {
        this.parentFigure = parentFigure;
    }

    public RotatedRectangle getRotatedRectangle() {
        return this.rotatedRect;
    }

    public Point[] getBoundPoints() {
        return this.rotatedRect.getPoints();
    }

    @Override
    public boolean isAllowResize() {
        return false;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.updateDisplayBox();
    }

    @Override
    public void drawFigure(Graphics2D g) {
        if (this.getText() == null) {
            return;
        }
        g.setFont(this.get(AttributeKeys.FONT_FACE));
        g.setColor(this.get(AttributeKeys.TEXT_COLOR));
        int padding = 2;
        if (this.get(AttributeKeys.ROTATION_ANGLE) == 0.0) {
            Rectangle r = this.getDisplayBox();
            g.drawString(this.getText(), r.x + padding, r.y + r.height - padding);
            this.updateRotatedRect(r);
        } else {
            g.drawImage((Image)this.rotatedText, padding, padding, null);
            this.rotateText(g);
        }
    }

    @Override
    protected void drawIndex(Graphics2D g) {
    }

    @Override
    protected void drawCaption(Graphics2D g) {
    }

    @Override
    public boolean isEmpty() {
        return this.text == null || this.text.trim().length() == 0;
    }

    @Override
    public void readAttributes(Map prop) {
        super.readAttributes(prop);
        Map ui = (Map)prop.get("ui");
        this.setText(DataUtil.decodeString("text", prop));
        Point pos = DataUtil.decodePoint("pos", ui);
        Dimension size = DataUtil.decodeSize("size", ui);
        this.setDisplayBox(pos.x, pos.y, pos.x + size.width, pos.y + size.height);
        this.updateDisplayBox();
    }

    @Override
    public Map toMap() {
        Map map = super.toMap();
        DataUtil.putValue(map, "text", this.getText());
        RotatedRectangle rr = this.getRotatedRectangle();
        Rectangle r = this.getDisplayBox();
        return map;
    }

    @Override
    public <T> void set(AttributeKey<T> key, T newValue) {
        super.set(key, newValue);
        if (this.getText() != null && "fontFace".equalsIgnoreCase(key.getKey())) {
            Rectangle r = this.getDisplayBox();
            Dimension size = DrawUtil.getTextSize(this.getText(), this.get(AttributeKeys.FONT_FACE));
            r.width = size.width;
            r.height = size.height;
            TextHandles.addHandles(this);
        }
    }

    private void rotateText(Graphics2D g) {
        if (this.get(AttributeKeys.ROTATION_ANGLE) == 0.0) {
            Rectangle r = this.getDisplayBox();
            Point[] pts = new Point[]{new Point(r.x, r.y), new Point(r.x + r.width, r.y), new Point(r.x + r.width, r.y + r.height), new Point(r.x, r.y + r.height)};
            this.rotatedRect.setPoints(pts);
            this.rotatedRect.setSize(new Dimension(r.width, r.height));
            this.rotatedRect.setCenter(new Point((int)r.getCenterX(), (int)r.getCenterY()));
            TextHandles.addHandles(this);
        } else {
            this.rotatedText = new BufferedImage(1000, 1000, 2);
            Graphics2D offscreen = this.rotatedText.createGraphics();
            offscreen.setFont(g.getFont());
            offscreen.setColor(g.getColor());
            DrawUtil.setHDRenderingHints(offscreen);
            Rectangle r = this.getDisplayBox();
            double cx = r.x + r.width / 2;
            double cy = r.y + r.height / 2;
            offscreen.rotate(Math.toRadians(-this.get(AttributeKeys.ROTATION_ANGLE).doubleValue()), cx, cy);
            FontMetrics metrics = offscreen.getFontMetrics();
            int ws = metrics.stringWidth(this.text);
            int hs = metrics.getDescent();
            float ux = (float)(cx - (double)ws / 2.0);
            float uy = (float)(cy + (double)hs);
            offscreen.drawString(this.text, ux, uy);
            this.rotateRect(g);
        }
    }

    private void rotateRect(Graphics g) {
        Rectangle r = this.getDisplayBox();
        int cx = r.x + r.width / 2;
        int cy = r.y + r.height / 2;
        Point[] pts = new Point[]{this.rotatePoint(cx, cy, r.x, r.y), this.rotatePoint(cx, cy, r.x + r.width, r.y), this.rotatePoint(cx, cy, r.x + r.width, r.y + r.height), this.rotatePoint(cx, cy, r.x, r.y + r.height)};
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        int maxx = Integer.MIN_VALUE;
        int maxy = Integer.MIN_VALUE;
        for (Point pt : pts) {
            if (pt.x < minx) {
                minx = pt.x;
            }
            if (pt.x > maxx) {
                maxx = pt.x;
            }
            if (pt.y < miny) {
                miny = pt.y;
            }
            if (pt.y <= maxy) continue;
            maxy = pt.y;
        }
        int rcx = minx + (Math.abs(maxx) - Math.abs(minx)) / 2;
        int rcy = miny + (Math.abs(maxy) - Math.abs(miny)) / 2;
        int rw = maxx - minx;
        int rh = maxy - miny;
        int dx = cx - maxx + rw / 2;
        int dy = cy - maxy + rh / 2;
        for (Point pt : pts) {
            pt.x += dx;
            pt.y += dy;
        }
        this.rotatedRect.setSize(new Dimension(rw, rh));
        this.rotatedRect.setPoints(pts);
        this.rotatedRect.setCenter(new Point(rcx, rcy));
        TextHandles.addHandles(this);
    }

    private Point rotatePoint(int cx, int cy, int x, int y) {
        double rad = Math.toRadians(this.get(AttributeKeys.ROTATION_ANGLE));
        double rx = (double)x * Math.cos(rad) + (double)y * Math.sin(rad);
        double ry = (double)(-x) * Math.sin(rad) + (double)y * Math.cos(rad);
        return new Point((int)rx, (int)ry);
    }

    @Override
    public void setRotation(int degree) {
        if ((double)degree != this.get(AttributeKeys.ROTATION_ANGLE)) {
            this.set(AttributeKeys.ROTATION_ANGLE, new Double(degree));
        }
    }

    @Override
    protected void move(int dx, int dy, MouseEvent e) {
        if (this.parentFigure != null && this.get(AttributeKeys.CENTER_TEXT).booleanValue()) {
            return;
        }
        super.move(dx, dy, e);
        for (Point pt : this.getRotatedRectangle().getPoints()) {
            if (pt == null) continue;
            pt.x += dx;
            pt.y += dy;
        }
        TextHandles.addHandles(this);
    }

    public void moveInner(int dx, int dy) {
        super.move(dx, dy, null);
        for (Point pt : this.getRotatedRectangle().getPoints()) {
            if (pt == null) continue;
            pt.x += dx;
            pt.y += dy;
        }
        TextHandles.addHandles(this);
    }

    private void updateDisplayBox() {
        if (this.getText() == null) {
            return;
        }
        BufferedImage bi = new BufferedImage(5, 5, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.setFont(this.get(AttributeKeys.FONT_FACE));
        FontMetrics fm = g2.getFontMetrics();
        int w = fm.stringWidth(this.getText());
        int h = fm.getHeight();
        Rectangle r = this.getDisplayBox();
        r.width = w;
        r.height = h;
        this.rotateText(g2);
        g2.dispose();
    }

    public void updateRotatedRect() {
        this.updateRotatedRect(this.getDisplayBox());
    }

    public void updateRotatedRect(Rectangle r) {
        this.rotatedRect.getPoints()[0] = new Point(r.x, r.y);
        this.rotatedRect.getPoints()[1] = new Point(r.x + r.width, r.y);
        this.rotatedRect.getPoints()[2] = new Point(r.x + r.width, r.y + r.height);
        this.rotatedRect.getPoints()[3] = new Point(r.x, r.y + r.height);
    }
}

