/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.figures;

import com.rameses.rcp.draw.decorators.ArrowTip;
import com.rameses.rcp.draw.figures.PolyLineFigure;
import com.rameses.rcp.draw.interfaces.Connector;
import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.interfaces.LineDecoration;
import com.rameses.rcp.draw.interfaces.Tool;
import com.rameses.rcp.draw.support.AttributeKeys;
import com.rameses.rcp.draw.tools.ConnectorTool;
import com.rameses.rcp.draw.utils.DataUtil;
import com.rameses.rcp.draw.utils.DrawUtil;
import com.rameses.rcp.draw.utils.Geom;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Map;

public class LineConnector
extends PolyLineFigure
implements Connector {
    private Figure startFigure;
    private Figure endFigure;

    public LineConnector() {
        this.addPoint(0, 0);
        this.addPoint(0, 0);
    }

    @Override
    public Tool getTool() {
        return new ConnectorTool();
    }

    @Override
    public String getToolCaption() {
        return "Arrow Connector";
    }

    @Override
    public String getIcon() {
        return "images/draw/connector16.png";
    }

    @Override
    public String getType() {
        return "arrow";
    }

    @Override
    public Rectangle getDisplayBox() {
        if (this.getPoints().isEmpty()) {
            return new Rectangle();
        }
        Rectangle r = null;
        for (Point p : this.getPoints()) {
            if (r == null) {
                r = new Rectangle(p);
            }
            r.add(p);
        }
        return r;
    }

    @Override
    protected void drawFigure(Graphics2D g) {
        super.drawFigure(g);
        this.drawDecoration(g);
    }

    @Override
    protected void drawCaption(Graphics2D g) {
        Figure innerText = this.getInnerText();
        if (innerText != null) {
            if (innerText.get(AttributeKeys.CENTER_TEXT).booleanValue()) {
                innerText.center(this.getCenterPoint());
            }
            innerText.draw(g);
        }
    }

    public void addPoint(int idx, Point pt) {
        this.getPoints().add(idx, pt);
        this.updateDisplayBox();
    }

    @Override
    public void moveBy(int dx, int dy, MouseEvent e, Figure sourceFigure) {
        Point p = null;
        if (sourceFigure == this.startFigure) {
            p = this.getStartPoint();
        } else if (sourceFigure == this.endFigure) {
            p = this.getEndPoint();
        }
        p.x += dx;
        p.y += dy;
        if (this.startFigure.getSelected() && this.endFigure.getSelected() && this.startFigure == sourceFigure) {
            for (int i = 1; i < this.getPoints().size() - 1; ++i) {
                Point pt = this.getPoints().get(i);
                pt.x += dx;
                pt.y += dy;
            }
            this.moveInnerText(dx, dy, e);
        }
    }

    @Override
    protected void moveInnerText(int dx, int dy, MouseEvent e) {
        if (this.getInnerText() != null) {
            this.getInnerText().moveBy(dx, dy, e);
        }
    }

    @Override
    public Figure getStartFigure() {
        return this.startFigure;
    }

    @Override
    public void setStartFigure(Figure figure) {
        this.setStartFigure(figure, true);
    }

    @Override
    public void setStartFigure(Figure figure, boolean updateConnectorPoint) {
        this.startFigure = figure;
        if (figure == null) {
            return;
        }
        if (updateConnectorPoint) {
            if (this.getPoints().isEmpty()) {
                this.addPoint(new Point(0, 0));
                this.addPoint(new Point(0, 0));
            }
            Point loc = figure.getDisplayBox().getLocation();
            Point p = this.getStartPoint();
            p.x = figure.getCenter().x;
            p.y = figure.getCenter().y;
        }
        figure.addConnector(this);
    }

    @Override
    public Figure getEndFigure() {
        return this.endFigure;
    }

    @Override
    public void setEndFigure(Figure figure) {
        this.setEndFigure(figure, true);
    }

    @Override
    public void setEndFigure(Figure figure, boolean updateConnectorPoint) {
        this.endFigure = figure;
        if (figure == null) {
            return;
        }
        if (updateConnectorPoint) {
            Point refPoint = this.getStartPoint();
            if (this.getPoints().size() > 2) {
                refPoint = this.getPoints().get(this.getPoints().size() - 2);
            }
            this.updateConnectionPoint(figure, refPoint, this.getEndPoint());
            refPoint = this.getEndPoint();
            if (this.getPoints().size() > 2) {
                refPoint = this.getPoints().get(1);
            }
            this.updateConnectionPoint(this.getStartFigure(), refPoint, this.getStartPoint());
        }
        figure.addConnector(this);
    }

    @Override
    public boolean isConnectionAllowed() {
        return false;
    }

    public Point getStartPoint() {
        return this.getPoints().get(0);
    }

    public Point getEndPoint() {
        return this.getPoints().get(this.getPoints().size() - 1);
    }

    @Override
    public LineDecoration getEndDecoration() {
        return new ArrowTip();
    }

    private void drawDecoration(Graphics2D g) {
        LineDecoration decoration;
        if (this.startFigure != null && this.endFigure != null && (decoration = this.getEndDecoration()) != null) {
            Point ps = this.getStartPoint();
            Point pe = this.getEndPoint();
            if (this.getPoints().size() > 2) {
                ps = this.getPoints().get(this.getPoints().size() - 2);
                pe = this.getPoints().get(this.getPoints().size() - 1);
            }
            Point2D.Double p1 = new Point2D.Double(pe.x, pe.y);
            Point2D.Double p2 = new Point2D.Double(ps.x, ps.y);
            decoration.draw(g, this.endFigure, p1, p2);
        }
    }

    @Override
    public boolean allowChop(int x, int y) {
        int tolerance = 5;
        for (Point p : this.getPoints()) {
            if (Math.abs(p.x - x) > tolerance || Math.abs(p.y - y) > tolerance) continue;
            return false;
        }
        return true;
    }

    @Override
    public Point chop(int x, int y, boolean split) {
        if (split) {
            int idx = this.findIndexFromPoints(x, y);
            Point p = new Point(x, y);
            this.addPoint(idx, p);
            return p;
        }
        int idx = this.findIndexFromPoints(x, y);
        this.getPoints().remove(idx);
        return null;
    }

    private int findIndexFromPoints(int x, int y) {
        if (this.getPoints().size() == 2) {
            return 1;
        }
        Point p1 = this.getPoints().get(0);
        for (int i = 1; i < this.getPoints().size(); ++i) {
            Point p2 = this.getPoints().get(i);
            if (Geom.pointInLine(p1.x, p1.y, p2.x, p2.y, x, y, 10.0)) {
                return i;
            }
            p1 = p2;
        }
        throw new RuntimeException("Invalid (x,y).");
    }

    protected void updateConnectionPoint(Figure figure, Point refPoint, Point pt) {
        if (figure == null) {
            return;
        }
        Point intersect = figure.intersect(refPoint);
        if (intersect != null) {
            pt.x = intersect.x;
            pt.y = intersect.y;
        } else {
            pt.x = figure.getCenter().x;
            pt.y = figure.getCenter().y;
        }
    }

    @Override
    public void readAttributes(Map prop) {
        super.readAttributes(prop);
        Map ui = (Map)prop.get("ui");
        this.readPoints(ui);
        this.readStartDecoration(ui);
        this.readEndDecoration(ui);
    }

    @Override
    public Map toMap() {
        Map map = super.toMap();
        map.put("startFigureId", this.getStartFigure().getId());
        map.put("endFigureId", this.getEndFigure().getId());
        return map;
    }

    private void readPoints(Map prop) {
        this.getPoints().clear();
        List<Point> points = DataUtil.decodePoints("points", prop);
        for (Point pt : points) {
            this.addPoint(pt);
        }
    }

    private void readStartDecoration(Map prop) {
        String decorationClass = (String)prop.get("startDecoration");
        if (decorationClass != null) {
            this.setStartDecoration((LineDecoration)DrawUtil.loadClass(decorationClass));
        }
    }

    private void readEndDecoration(Map prop) {
        String decorationClass = (String)prop.get("endDecoration");
        if (decorationClass != null) {
            this.setEndDecoration((LineDecoration)DrawUtil.loadClass(decorationClass));
        }
    }

    private Point getCenterPoint() {
        int size = this.getPoints().size();
        Point center = new Point(this.getCenter());
        if (size >= 2) {
            if (size % 2 == 0) {
                int index1 = size / 2 - 1;
                int index2 = size / 2;
                Point p1 = this.getPoints().get(index1);
                Point p2 = this.getPoints().get(index2);
                center = this.getCenterPoint(p1, p2);
            } else {
                int index = size / 2;
                center = this.getPoints().get(index);
            }
        }
        return center;
    }

    private Point getCenterPoint(Point p1, Point p2) {
        int x = Math.min(p1.x, p2.x) + Math.abs(p1.x - p2.x) / 2;
        int y = Math.min(p1.y, p2.y) + Math.abs(p1.y - p2.y) / 2;
        return new Point(x, y - 10);
    }
}

