/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.figures;

import com.rameses.rcp.draw.figures.AbstractAttributedFigure;
import com.rameses.rcp.draw.handles.BoxHandle;
import com.rameses.rcp.draw.interfaces.Tool;
import com.rameses.rcp.draw.tools.ImageTool;
import com.rameses.rcp.draw.utils.DataUtil;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Map;

public class ImageFigure
extends AbstractAttributedFigure {
    private transient Image image;
    private String imageFile;

    public ImageFigure() {
        BoxHandle.addHandles(this);
    }

    @Override
    public String getToolCaption() {
        return "Image";
    }

    @Override
    public String getType() {
        return "image";
    }

    @Override
    public Tool getTool() {
        return new ImageTool();
    }

    @Override
    public String getIcon() {
        return "images/draw/image16.png";
    }

    @Override
    public void setDisplayBox(int x1, int y1, int x2, int y2) {
        if (this.isAllowResize()) {
            super.setDisplayBox(x1, y1, x2, y2);
        } else {
            Dimension dm = this.getSize();
            super.setDisplayBox(new Rectangle(x1 - dm.width / 2, y1 - dm.height / 2, (int)dm.getWidth(), (int)dm.getHeight()));
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setImage(String imageFile) {
        this.imageFile = imageFile;
        this.setImage(DataUtil.decodeImage(imageFile));
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(String imageFile) {
        this.imageFile = imageFile;
    }

    public Dimension getSize() {
        return this.getImageDimension();
    }

    @Override
    protected void drawFigure(Graphics2D g) {
        Rectangle r = this.getDisplayBox();
        if (this.image == null) {
            g.drawRect(r.x, r.y, r.width, r.height);
        } else {
            Image scaledImage = this.getScaledImage(r);
            g.drawImage(scaledImage, r.x, r.y, null);
        }
    }

    @Override
    public boolean isEmpty() {
        Rectangle r = this.getDisplayBox();
        return this.image == null || r.width <= 2 || r.height <= 2;
    }

    private Image getScaledImage(Rectangle r) {
        if (this.image != null && r.width > 0 && r.height > 0) {
            BufferedImage bi = new BufferedImage(r.width, r.height, 2);
            Graphics2D g = bi.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(this.image, 0, 0, r.width, r.height, null);
            g.dispose();
            return bi;
        }
        return null;
    }

    private Dimension getImageDimension() {
        Dimension d = null;
        if (this.image != null) {
            BufferedImage img = new BufferedImage(this.image.getWidth(null), this.image.getHeight(null), 2);
            d = new Dimension(img.getWidth(), img.getHeight());
        } else {
            d = new Dimension(24, 24);
        }
        return d;
    }

    @Override
    public void readAttributes(Map prop) {
        super.readAttributes(prop);
        Map ui = (Map)prop.get("ui");
        this.setImage(DataUtil.decodeImage("image", ui));
        Point pos = DataUtil.decodePoint("pos", ui);
        Dimension size = DataUtil.decodeSize("size", ui);
        if (size == null) {
            size = this.getSize();
        }
        this.setDisplayBox(pos.x, pos.y, pos.x + size.width, pos.y + size.height);
        this.recalcLocation(pos);
    }

    @Override
    public Map toMap() {
        Map map = super.toMap();
        Map ui = (Map)map.get("ui");
        if (this.imageFile != null) {
            ui.put("image", this.imageFile);
        } else if (this.image != null) {
            ui.put("image", DataUtil.encode(this.image));
        }
        return map;
    }

    private void recalcLocation(Point pos) {
        Rectangle r = this.getDisplayBox();
        r.x = pos.x;
        r.y = pos.y;
    }
}

