/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.figures;

import com.rameses.rcp.draw.figures.TextFigure;
import com.rameses.rcp.draw.interfaces.Canvas;
import com.rameses.rcp.draw.support.AttributeKeys;
import com.rameses.rcp.draw.tools.TextTool;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import javax.swing.JTextField;

public class FloatingTextField
implements KeyListener,
ActionListener {
    private TextTool tool;
    private Canvas canvas;
    private JTextField textField = new JTextField(10);
    private TextFigure editedFigure;

    public void createOverlay(TextTool tool, Canvas canvas, TextFigure figure) {
        canvas.getContainer().add((Component)this.textField, 0);
        this.tool = tool;
        this.canvas = canvas;
        this.textField.setText(figure.getText());
        this.textField.selectAll();
        this.textField.setVisible(true);
        this.textField.requestFocus();
        this.textField.addKeyListener(this);
        this.textField.addActionListener(this);
        this.editedFigure = figure;
        this.updateWidget();
    }

    public void setBounds(Rectangle r, String text) {
        this.textField.setText(text);
        this.textField.setLocation(r.x, r.y);
        this.textField.setSize(r.width, r.height);
        this.textField.setVisible(true);
        this.textField.selectAll();
        this.textField.requestFocus();
    }

    protected void updateWidget() {
        Rectangle r = this.editedFigure.getDisplayBox();
        Font font = this.editedFigure.get(AttributeKeys.FONT_FACE);
        this.textField.setFont(font);
        this.textField.setForeground(this.editedFigure.get(AttributeKeys.TEXT_COLOR));
        this.textField.setBackground(this.editedFigure.get(AttributeKeys.TEXT_BACKGROUND));
        Dimension ps = this.textField.getPreferredSize();
        Insets tfInsets = this.textField.getInsets();
        this.textField.setBounds(r.x - tfInsets.left, r.y - tfInsets.top, Math.max(r.width + tfInsets.left + tfInsets.right, ps.width), Math.max(r.height + tfInsets.top + tfInsets.bottom, ps.height));
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public Dimension getPreferredSize(int cols) {
        this.textField.setColumns(cols);
        return this.textField.getPreferredSize();
    }

    public void endOverlay() {
        this.canvas.getContainer().requestFocus();
        if (this.textField != null) {
            this.editedFigure.setText(this.textField.getText());
            this.adjustFigureDisplayBox();
            this.textField.setVisible(false);
            this.canvas.getContainer().remove(this.textField);
            this.textField = null;
        }
    }

    private void adjustFigureDisplayBox() {
        if (this.getText() == null) {
            return;
        }
        Font font = this.editedFigure.get(AttributeKeys.FONT_FACE);
        BufferedImage bi = new BufferedImage(10, 10, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.setFont(font);
        FontMetrics metrics = g2.getFontMetrics(font);
        int w = metrics.stringWidth(this.getText());
        int h = metrics.getHeight();
        Rectangle r = this.editedFigure.getDisplayBox();
        r.width = w;
        r.height = h;
        r.grow(2, 4);
        this.editedFigure.setDisplayBox(r);
        g2.dispose();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int id = e.getID();
        if (id != 400 && e.getKeyCode() == 27) {
            this.tool.cancel();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.tool.endEdit();
    }
}

